# Generated by default/object.tt
package Paws::MediaTailor::HttpPackageConfiguration;
  use Moose;
  has Path => (is => 'ro', isa => 'Str', required => 1);
  has SourceGroup => (is => 'ro', isa => 'Str', required => 1);
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::HttpPackageConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::HttpPackageConfiguration object:

  $service_obj->Method(Att1 => { Path => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::HttpPackageConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->Path

=head1 DESCRIPTION

The HTTP package configuration properties for the requested VOD source.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Path => Str

The relative path to the URL for this VOD source. This is combined with
SourceLocation::HttpConfiguration::BaseUrl to form a valid URL.


=head2 B<REQUIRED> SourceGroup => Str

The name of the source group. This has to match one of the
Channel::Outputs::SourceGroup.


=head2 B<REQUIRED> Type => Str

The streaming protocol for this package configuration. Supported values
are HLS and DASH.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

