# Generated by default/object.tt
package Paws::MediaLive::ListInputDeviceTransfersResultModel;
  use Moose;
  has InputDeviceTransfers => (is => 'ro', isa => 'ArrayRef[Paws::MediaLive::TransferringInputDeviceSummary]', request_name => 'inputDeviceTransfers', traits => ['NameInRequest']);
  has NextToken => (is => 'ro', isa => 'Str', request_name => 'nextToken', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::ListInputDeviceTransfersResultModel

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::ListInputDeviceTransfersResultModel object:

  $service_obj->Method(Att1 => { InputDeviceTransfers => $value, ..., NextToken => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::ListInputDeviceTransfersResultModel object:

  $result = $service_obj->Method(...);
  $result->Att1->InputDeviceTransfers

=head1 DESCRIPTION

The list of input devices in the transferred state. The recipient
hasn't yet accepted or rejected the transfer.

=head1 ATTRIBUTES


=head2 InputDeviceTransfers => ArrayRef[L<Paws::MediaLive::TransferringInputDeviceSummary>]

The list of devices that you are transferring or are being transferred
to you.


=head2 NextToken => Str

A token to get additional list results.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

