# Generated by default/object.tt
package Paws::Macie2::PolicyDetails;
  use Moose;
  has Action => (is => 'ro', isa => 'Paws::Macie2::FindingAction', request_name => 'action', traits => ['NameInRequest']);
  has Actor => (is => 'ro', isa => 'Paws::Macie2::FindingActor', request_name => 'actor', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::PolicyDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::PolicyDetails object:

  $service_obj->Method(Att1 => { Action => $value, ..., Actor => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::PolicyDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

Provides the details of a policy finding.

=head1 ATTRIBUTES


=head2 Action => L<Paws::Macie2::FindingAction>

The action that produced the finding.


=head2 Actor => L<Paws::Macie2::FindingActor>

The entity that performed the action that produced the finding.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

