# Generated by default/object.tt
package Paws::Macie2::MonthlySchedule;
  use Moose;
  has DayOfMonth => (is => 'ro', isa => 'Int', request_name => 'dayOfMonth', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::MonthlySchedule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::MonthlySchedule object:

  $service_obj->Method(Att1 => { DayOfMonth => $value, ..., DayOfMonth => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::MonthlySchedule object:

  $result = $service_obj->Method(...);
  $result->Att1->DayOfMonth

=head1 DESCRIPTION

Specifies a monthly recurrence pattern for running a classification
job.

=head1 ATTRIBUTES


=head2 DayOfMonth => Int

The numeric day of the month when Amazon Macie runs the job. This value
can be an integer from 1 through 31.

If this value exceeds the number of days in a certain month, Macie
doesn't run the job that month. Macie runs the job only during months
that have the specified day. For example, if this value is 31 and a
month has only 30 days, Macie doesn't run the job that month. To run
the job every month, specify a value that's less than 29.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

