# Generated by default/object.tt
package Paws::Lightsail::Alarm;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has ComparisonOperator => (is => 'ro', isa => 'Str', request_name => 'comparisonOperator', traits => ['NameInRequest']);
  has ContactProtocols => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'contactProtocols', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has DatapointsToAlarm => (is => 'ro', isa => 'Int', request_name => 'datapointsToAlarm', traits => ['NameInRequest']);
  has EvaluationPeriods => (is => 'ro', isa => 'Int', request_name => 'evaluationPeriods', traits => ['NameInRequest']);
  has Location => (is => 'ro', isa => 'Paws::Lightsail::ResourceLocation', request_name => 'location', traits => ['NameInRequest']);
  has MetricName => (is => 'ro', isa => 'Str', request_name => 'metricName', traits => ['NameInRequest']);
  has MonitoredResourceInfo => (is => 'ro', isa => 'Paws::Lightsail::MonitoredResourceInfo', request_name => 'monitoredResourceInfo', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has NotificationEnabled => (is => 'ro', isa => 'Bool', request_name => 'notificationEnabled', traits => ['NameInRequest']);
  has NotificationTriggers => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'notificationTriggers', traits => ['NameInRequest']);
  has Period => (is => 'ro', isa => 'Int', request_name => 'period', traits => ['NameInRequest']);
  has ResourceType => (is => 'ro', isa => 'Str', request_name => 'resourceType', traits => ['NameInRequest']);
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest']);
  has Statistic => (is => 'ro', isa => 'Str', request_name => 'statistic', traits => ['NameInRequest']);
  has SupportCode => (is => 'ro', isa => 'Str', request_name => 'supportCode', traits => ['NameInRequest']);
  has Threshold => (is => 'ro', isa => 'Num', request_name => 'threshold', traits => ['NameInRequest']);
  has TreatMissingData => (is => 'ro', isa => 'Str', request_name => 'treatMissingData', traits => ['NameInRequest']);
  has Unit => (is => 'ro', isa => 'Str', request_name => 'unit', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::Alarm

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::Alarm object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Unit => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::Alarm object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Describes an alarm.

An alarm is a way to monitor your Amazon Lightsail resource metrics.
For more information, see Alarms in Amazon Lightsail
(https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the alarm.


=head2 ComparisonOperator => Str

The arithmetic operation used when comparing the specified statistic
and threshold.


=head2 ContactProtocols => ArrayRef[Str|Undef]

The contact protocols for the alarm, such as C<Email>, C<SMS> (text
messaging), or both.


=head2 CreatedAt => Str

The timestamp when the alarm was created.


=head2 DatapointsToAlarm => Int

The number of data points that must not within the specified threshold
to trigger the alarm.


=head2 EvaluationPeriods => Int

The number of periods over which data is compared to the specified
threshold.


=head2 Location => L<Paws::Lightsail::ResourceLocation>

An object that lists information about the location of the alarm.


=head2 MetricName => Str

The name of the metric associated with the alarm.


=head2 MonitoredResourceInfo => L<Paws::Lightsail::MonitoredResourceInfo>

An object that lists information about the resource monitored by the
alarm.


=head2 Name => Str

The name of the alarm.


=head2 NotificationEnabled => Bool

Indicates whether the alarm is enabled.


=head2 NotificationTriggers => ArrayRef[Str|Undef]

The alarm states that trigger a notification.


=head2 Period => Int

The period, in seconds, over which the statistic is applied.


=head2 ResourceType => Str

The Lightsail resource type (e.g., C<Alarm>).


=head2 State => Str

The current state of the alarm.

An alarm has the following possible states:

=over

=item *

C<ALARM> - The metric is outside of the defined threshold.

=item *

C<INSUFFICIENT_DATA> - The alarm has just started, the metric is not
available, or not enough data is available for the metric to determine
the alarm state.

=item *

C<OK> - The metric is within the defined threshold.

=back



=head2 Statistic => Str

The statistic for the metric associated with the alarm.

The following statistics are available:

=over

=item *

C<Minimum> - The lowest value observed during the specified period. Use
this value to determine low volumes of activity for your application.

=item *

C<Maximum> - The highest value observed during the specified period.
Use this value to determine high volumes of activity for your
application.

=item *

C<Sum> - All values submitted for the matching metric added together.
You can use this statistic to determine the total volume of a metric.

=item *

C<Average> - The value of Sum / SampleCount during the specified
period. By comparing this statistic with the Minimum and Maximum
values, you can determine the full scope of a metric and how close the
average use is to the Minimum and Maximum values. This comparison helps
you to know when to increase or decrease your resources.

=item *

C<SampleCount> - The count, or number, of data points used for the
statistical calculation.

=back



=head2 SupportCode => Str

The support code. Include this code in your email to support when you
have questions about your Lightsail alarm. This code enables our
support team to look up your Lightsail information more easily.


=head2 Threshold => Num

The value against which the specified statistic is compared.


=head2 TreatMissingData => Str

Specifies how the alarm handles missing data points.

An alarm can treat missing data in the following ways:

=over

=item *

C<breaching> - Assume the missing data is not within the threshold.
Missing data counts towards the number of times the metric is not
within the threshold.

=item *

C<notBreaching> - Assume the missing data is within the threshold.
Missing data does not count towards the number of times the metric is
not within the threshold.

=item *

C<ignore> - Ignore the missing data. Maintains the current alarm state.

=item *

C<missing> - Missing data is treated as missing.

=back



=head2 Unit => Str

The unit of the metric associated with the alarm.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

