# Generated by default/object.tt
package Paws::LexModelsV2::SlotTypeSummary;
  use Moose;
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has LastUpdatedDateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedDateTime', traits => ['NameInRequest']);
  has ParentSlotTypeSignature => (is => 'ro', isa => 'Str', request_name => 'parentSlotTypeSignature', traits => ['NameInRequest']);
  has SlotTypeId => (is => 'ro', isa => 'Str', request_name => 'slotTypeId', traits => ['NameInRequest']);
  has SlotTypeName => (is => 'ro', isa => 'Str', request_name => 'slotTypeName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::SlotTypeSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::SlotTypeSummary object:

  $service_obj->Method(Att1 => { Description => $value, ..., SlotTypeName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::SlotTypeSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Provides summary information about a slot type.

=head1 ATTRIBUTES


=head2 Description => Str

The description of the slot type.


=head2 LastUpdatedDateTime => Str

A timestamp of the date and time that the slot type was last updated.


=head2 ParentSlotTypeSignature => Str

If the slot type is derived from a built-on slot type, the name of the
parent slot type.


=head2 SlotTypeId => Str

The unique identifier assigned to the slot type.


=head2 SlotTypeName => Str

The name of the slot type.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

