# Generated by default/object.tt
package Paws::Kendra::Suggestion;
  use Moose;
  has Id => (is => 'ro', isa => 'Str');
  has Value => (is => 'ro', isa => 'Paws::Kendra::SuggestionValue');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::Suggestion

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::Suggestion object:

  $service_obj->Method(Att1 => { Id => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::Suggestion object:

  $result = $service_obj->Method(...);
  $result->Att1->Id

=head1 DESCRIPTION

A single query suggestion.

=head1 ATTRIBUTES


=head2 Id => Str

The unique UUID (universally unique identifier) of a single query
suggestion.


=head2 Value => L<Paws::Kendra::SuggestionValue>

The value for the unique UUID (universally unique identifier) of a
single query suggestion.

The value is the text string of a suggestion.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

