# Generated by default/object.tt
package Paws::Kendra::GoogleDriveConfiguration;
  use Moose;
  has ExcludeMimeTypes => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ExcludeSharedDrives => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ExcludeUserAccounts => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ExclusionPatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has FieldMappings => (is => 'ro', isa => 'ArrayRef[Paws::Kendra::DataSourceToIndexFieldMapping]');
  has InclusionPatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has SecretArn => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::GoogleDriveConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::GoogleDriveConfiguration object:

  $service_obj->Method(Att1 => { ExcludeMimeTypes => $value, ..., SecretArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::GoogleDriveConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ExcludeMimeTypes

=head1 DESCRIPTION

Provides configuration information for data sources that connect to
Google Drive.

=head1 ATTRIBUTES


=head2 ExcludeMimeTypes => ArrayRef[Str|Undef]

A list of MIME types to exclude from the index. All documents matching
the specified MIME type are excluded.

For a list of MIME types, see Using a Google Workspace Drive data
source
(https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html).


=head2 ExcludeSharedDrives => ArrayRef[Str|Undef]

A list of identifiers or shared drives to exclude from the index. All
files and folders stored on the shared drive are excluded.


=head2 ExcludeUserAccounts => ArrayRef[Str|Undef]

A list of email addresses of the users. Documents owned by these users
are excluded from the index. Documents shared with excluded users are
indexed unless they are excluded in another way.


=head2 ExclusionPatterns => ArrayRef[Str|Undef]

A list of regular expression patterns that apply to the path on Google
Drive. Items that match the pattern are excluded from the index from
both shared drives and users' My Drives. Items that don't match the
pattern are included in the index. If an item matches both an exclusion
pattern and an inclusion pattern, it is excluded from the index.


=head2 FieldMappings => ArrayRef[L<Paws::Kendra::DataSourceToIndexFieldMapping>]

Defines mapping between a field in the Google Drive and a Amazon Kendra
index field.

If you are using the console, you can define index fields when creating
the mapping. If you are using the API, you must first create the field
using the C<UpdateIndex> operation.


=head2 InclusionPatterns => ArrayRef[Str|Undef]

A list of regular expression patterns that apply to path on Google
Drive. Items that match the pattern are included in the index from both
shared drives and users' My Drives. Items that don't match the pattern
are excluded from the index. If an item matches both an inclusion
pattern and an exclusion pattern, it is excluded from the index.


=head2 B<REQUIRED> SecretArn => Str

The Amazon Resource Name (ARN) of a AWS Secrets Manager secret that
contains the credentials required to connect to Google Drive. For more
information, see Using a Google Workspace Drive data source
(https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

