# Generated by default/object.tt
package Paws::KMS::MultiRegionConfiguration;
  use Moose;
  has MultiRegionKeyType => (is => 'ro', isa => 'Str');
  has PrimaryKey => (is => 'ro', isa => 'Paws::KMS::MultiRegionKey');
  has ReplicaKeys => (is => 'ro', isa => 'ArrayRef[Paws::KMS::MultiRegionKey]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::KMS::MultiRegionConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::KMS::MultiRegionConfiguration object:

  $service_obj->Method(Att1 => { MultiRegionKeyType => $value, ..., ReplicaKeys => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::KMS::MultiRegionConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->MultiRegionKeyType

=head1 DESCRIPTION

Describes the configuration of this multi-Region CMK. This field
appears only when the CMK is a primary or replica of a multi-Region
CMK.

For more information about any listed CMK, use the DescribeKey
operation.

=head1 ATTRIBUTES


=head2 MultiRegionKeyType => Str

Indicates whether the CMK is a C<PRIMARY> or C<REPLICA> key.


=head2 PrimaryKey => L<Paws::KMS::MultiRegionKey>

Displays the key ARN and Region of the primary key. This field includes
the current CMK if it is the primary key.


=head2 ReplicaKeys => ArrayRef[L<Paws::KMS::MultiRegionKey>]

displays the key ARNs and Regions of all replica keys. This field
includes the current CMK if it is a replica key.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::KMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

