# Generated by default/object.tt
package Paws::IoTSiteWise::PropertyNotification;
  use Moose;
  has State => (is => 'ro', isa => 'Str', request_name => 'state', traits => ['NameInRequest'], required => 1);
  has Topic => (is => 'ro', isa => 'Str', request_name => 'topic', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::PropertyNotification

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::PropertyNotification object:

  $service_obj->Method(Att1 => { State => $value, ..., Topic => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::PropertyNotification object:

  $result = $service_obj->Method(...);
  $result->Att1->State

=head1 DESCRIPTION

Contains asset property value notification information. When the
notification state is enabled, AWS IoT SiteWise publishes property
value updates to a unique MQTT topic. For more information, see
Interacting with other services
(https://docs.aws.amazon.com/iot-sitewise/latest/userguide/interact-with-other-services.html)
in the I<AWS IoT SiteWise User Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> State => Str

The current notification state.


=head2 B<REQUIRED> Topic => Str

The MQTT topic to which AWS IoT SiteWise publishes property value
update notifications.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

