# Generated by default/object.tt
package Paws::IoTFleetHub::ApplicationSummary;
  use Moose;
  has ApplicationCreationDate => (is => 'ro', isa => 'Int', request_name => 'applicationCreationDate', traits => ['NameInRequest']);
  has ApplicationDescription => (is => 'ro', isa => 'Str', request_name => 'applicationDescription', traits => ['NameInRequest']);
  has ApplicationId => (is => 'ro', isa => 'Str', request_name => 'applicationId', traits => ['NameInRequest'], required => 1);
  has ApplicationLastUpdateDate => (is => 'ro', isa => 'Int', request_name => 'applicationLastUpdateDate', traits => ['NameInRequest']);
  has ApplicationName => (is => 'ro', isa => 'Str', request_name => 'applicationName', traits => ['NameInRequest'], required => 1);
  has ApplicationState => (is => 'ro', isa => 'Str', request_name => 'applicationState', traits => ['NameInRequest']);
  has ApplicationUrl => (is => 'ro', isa => 'Str', request_name => 'applicationUrl', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTFleetHub::ApplicationSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTFleetHub::ApplicationSummary object:

  $service_obj->Method(Att1 => { ApplicationCreationDate => $value, ..., ApplicationUrl => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTFleetHub::ApplicationSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ApplicationCreationDate

=head1 DESCRIPTION

A summary of information about a AWS IoT Device Management web
application.

Fleet Hub for AWS IoT Device Management is in public preview and is
subject to change.

=head1 ATTRIBUTES


=head2 ApplicationCreationDate => Int

The date (in Unix epoch time) when the web application was created.


=head2 ApplicationDescription => Str

An optional description of the web application.


=head2 B<REQUIRED> ApplicationId => Str

The unique Id of the web application.


=head2 ApplicationLastUpdateDate => Int

The date (in Unix epoch time) when the web application was last
updated.


=head2 B<REQUIRED> ApplicationName => Str

The name of the web application.


=head2 ApplicationState => Str

The current state of the web application.


=head2 B<REQUIRED> ApplicationUrl => Str

The URL of the web application.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTFleetHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

