# Generated by default/object.tt
package Paws::IoTEvents::SimpleRule;
  use Moose;
  has ComparisonOperator => (is => 'ro', isa => 'Str', request_name => 'comparisonOperator', traits => ['NameInRequest'], required => 1);
  has InputProperty => (is => 'ro', isa => 'Str', request_name => 'inputProperty', traits => ['NameInRequest'], required => 1);
  has Threshold => (is => 'ro', isa => 'Str', request_name => 'threshold', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::SimpleRule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::SimpleRule object:

  $service_obj->Method(Att1 => { ComparisonOperator => $value, ..., Threshold => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::SimpleRule object:

  $result = $service_obj->Method(...);
  $result->Att1->ComparisonOperator

=head1 DESCRIPTION

A rule that compares an input property value to a threshold value with
a comparison operator.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ComparisonOperator => Str

The comparison operator.


=head2 B<REQUIRED> InputProperty => Str

The value on the left side of the comparison operator. You can specify
an AWS IoT Events input attribute as an input property.


=head2 B<REQUIRED> Threshold => Str

The value on the right side of the comparison operator. You can enter a
number or specify an AWS IoT Events input attribute.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

