# Generated by default/object.tt
package Paws::GreengrassV2::LambdaVolumeMount;
  use Moose;
  has AddGroupOwner => (is => 'ro', isa => 'Bool', request_name => 'addGroupOwner', traits => ['NameInRequest']);
  has DestinationPath => (is => 'ro', isa => 'Str', request_name => 'destinationPath', traits => ['NameInRequest'], required => 1);
  has Permission => (is => 'ro', isa => 'Str', request_name => 'permission', traits => ['NameInRequest']);
  has SourcePath => (is => 'ro', isa => 'Str', request_name => 'sourcePath', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::LambdaVolumeMount

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::LambdaVolumeMount object:

  $service_obj->Method(Att1 => { AddGroupOwner => $value, ..., SourcePath => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::LambdaVolumeMount object:

  $result = $service_obj->Method(...);
  $result->Att1->AddGroupOwner

=head1 DESCRIPTION

Contains information about a volume that Linux processes in a container
can access. When you define a volume, the AWS IoT Greengrass Core
software mounts the source files to the destination inside the
container.

=head1 ATTRIBUTES


=head2 AddGroupOwner => Bool

Whether or not to add the AWS IoT Greengrass user group as an owner of
the volume.

Default: C<false>


=head2 B<REQUIRED> DestinationPath => Str

The path to the logical volume in the file system.


=head2 Permission => Str

The permission to access the volume: read/only (C<ro>) or read/write
(C<rw>).

Default: C<ro>


=head2 B<REQUIRED> SourcePath => Str

The path to the physical volume in the file system.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

