# Generated by default/object.tt
package Paws::GreengrassV2::LambdaEventSource;
  use Moose;
  has Topic => (is => 'ro', isa => 'Str', request_name => 'topic', traits => ['NameInRequest'], required => 1);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GreengrassV2::LambdaEventSource

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GreengrassV2::LambdaEventSource object:

  $service_obj->Method(Att1 => { Topic => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GreengrassV2::LambdaEventSource object:

  $result = $service_obj->Method(...);
  $result->Att1->Topic

=head1 DESCRIPTION

Contains information about an event source for an AWS Lambda function.
The event source defines the topics on which this Lambda function
subscribes to receive messages that run the function.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Topic => Str

The topic to which to subscribe to receive event messages.


=head2 B<REQUIRED> Type => Str

The type of event source. Choose from the following options:

=over

=item *

C<PUB_SUB> E<ndash> Subscribe to local publish/subscribe messages. This
event source type doesn't support MQTT wildcards (C<+> and C<#>) in the
event source topic.

=item *

C<IOT_CORE> E<ndash> Subscribe to AWS IoT Core MQTT messages. This
event source type supports MQTT wildcards (C<+> and C<#>) in the event
source topic.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GreengrassV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

