# Generated by default/object.tt
package Paws::GlueDataBrew::ViewFrame;
  use Moose;
  has ColumnRange => (is => 'ro', isa => 'Int');
  has HiddenColumns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has StartColumnIndex => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::ViewFrame

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::ViewFrame object:

  $service_obj->Method(Att1 => { ColumnRange => $value, ..., StartColumnIndex => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::ViewFrame object:

  $result = $service_obj->Method(...);
  $result->Att1->ColumnRange

=head1 DESCRIPTION

Represents the data being transformed during an action.

=head1 ATTRIBUTES


=head2 ColumnRange => Int

The number of columns to include in the view frame, beginning with the
C<StartColumnIndex> value and ignoring any columns in the
C<HiddenColumns> list.


=head2 HiddenColumns => ArrayRef[Str|Undef]

A list of columns to hide in the view frame.


=head2 B<REQUIRED> StartColumnIndex => Int

The starting index for the range of columns to return in the view
frame.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

