# Generated by default/object.tt
package Paws::Glue::SchemaVersionListItem;
  use Moose;
  has CreatedTime => (is => 'ro', isa => 'Str');
  has SchemaArn => (is => 'ro', isa => 'Str');
  has SchemaVersionId => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has VersionNumber => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::SchemaVersionListItem

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::SchemaVersionListItem object:

  $service_obj->Method(Att1 => { CreatedTime => $value, ..., VersionNumber => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::SchemaVersionListItem object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedTime

=head1 DESCRIPTION

An object containing the details about a schema version.

=head1 ATTRIBUTES


=head2 CreatedTime => Str

The date and time the schema version was created.


=head2 SchemaArn => Str

The Amazon Resource Name (ARN) of the schema.


=head2 SchemaVersionId => Str

The unique identifier of the schema version.


=head2 Status => Str

The status of the schema version.


=head2 VersionNumber => Int

The version number of the schema.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

