# Generated by default/object.tt
package Paws::ECR::EncryptionConfiguration;
  use Moose;
  has EncryptionType => (is => 'ro', isa => 'Str', request_name => 'encryptionType', traits => ['NameInRequest'], required => 1);
  has KmsKey => (is => 'ro', isa => 'Str', request_name => 'kmsKey', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECR::EncryptionConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECR::EncryptionConfiguration object:

  $service_obj->Method(Att1 => { EncryptionType => $value, ..., KmsKey => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECR::EncryptionConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->EncryptionType

=head1 DESCRIPTION

The encryption configuration for the repository. This determines how
the contents of your repository are encrypted at rest.

By default, when no encryption configuration is set or the C<AES256>
encryption type is used, Amazon ECR uses server-side encryption with
Amazon S3-managed encryption keys which encrypts your data at rest
using an AES-256 encryption algorithm. This does not require any action
on your part.

For more control over the encryption of the contents of your
repository, you can use server-side encryption with customer master
keys (CMKs) stored in AWS Key Management Service (AWS KMS) to encrypt
your images. For more information, see Amazon ECR encryption at rest
(https://docs.aws.amazon.com/AmazonECR/latest/userguide/encryption-at-rest.html)
in the I<Amazon Elastic Container Registry User Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> EncryptionType => Str

The encryption type to use.

If you use the C<KMS> encryption type, the contents of the repository
will be encrypted using server-side encryption with customer master
keys (CMKs) stored in AWS KMS. When you use AWS KMS to encrypt your
data, you can either use the default AWS managed CMK for Amazon ECR, or
specify your own CMK, which you already created. For more information,
see Protecting Data Using Server-Side Encryption with CMKs Stored in
AWS Key Management Service (SSE-KMS)
(https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html)
in the I<Amazon Simple Storage Service Console Developer Guide.>.

If you use the C<AES256> encryption type, Amazon ECR uses server-side
encryption with Amazon S3-managed encryption keys which encrypts the
images in the repository using an AES-256 encryption algorithm. For
more information, see Protecting Data Using Server-Side Encryption with
Amazon S3-Managed Encryption Keys (SSE-S3)
(https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html)
in the I<Amazon Simple Storage Service Console Developer Guide.>.


=head2 KmsKey => Str

If you use the C<KMS> encryption type, specify the CMK to use for
encryption. The alias, key ID, or full ARN of the CMK can be specified.
The key must exist in the same Region as the repository. If no key is
specified, the default AWS managed CMK for Amazon ECR will be used.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECR>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

