# Generated by default/object.tt
package Paws::DevOpsGuru::Recommendation;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has Link => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Reason => (is => 'ro', isa => 'Str');
  has RelatedAnomalies => (is => 'ro', isa => 'ArrayRef[Paws::DevOpsGuru::RecommendationRelatedAnomaly]');
  has RelatedEvents => (is => 'ro', isa => 'ArrayRef[Paws::DevOpsGuru::RecommendationRelatedEvent]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::Recommendation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::Recommendation object:

  $service_obj->Method(Att1 => { Description => $value, ..., RelatedEvents => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::Recommendation object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Recommendation information to help you remediate detected anomalous
behavior that generated an insight.

=head1 ATTRIBUTES


=head2 Description => Str

A description of the problem.


=head2 Link => Str

A hyperlink to information to help you address the problem.


=head2 Name => Str

The name of the recommendation.


=head2 Reason => Str

The reason DevOps Guru flagged the anomalous behavior as a problem.


=head2 RelatedAnomalies => ArrayRef[L<Paws::DevOpsGuru::RecommendationRelatedAnomaly>]

Anomalies that are related to the problem. Use these Anomalies to learn
more about what's happening and to help address the issue.


=head2 RelatedEvents => ArrayRef[L<Paws::DevOpsGuru::RecommendationRelatedEvent>]

Events that are related to the problem. Use these events to learn more
about what's happening and to help address the issue.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

