# Generated by default/object.tt
package Paws::DMS::TableStatistics;
  use Moose;
  has Ddls => (is => 'ro', isa => 'Int');
  has Deletes => (is => 'ro', isa => 'Int');
  has FullLoadCondtnlChkFailedRows => (is => 'ro', isa => 'Int');
  has FullLoadEndTime => (is => 'ro', isa => 'Str');
  has FullLoadErrorRows => (is => 'ro', isa => 'Int');
  has FullLoadReloaded => (is => 'ro', isa => 'Bool');
  has FullLoadRows => (is => 'ro', isa => 'Int');
  has FullLoadStartTime => (is => 'ro', isa => 'Str');
  has Inserts => (is => 'ro', isa => 'Int');
  has LastUpdateTime => (is => 'ro', isa => 'Str');
  has SchemaName => (is => 'ro', isa => 'Str');
  has TableName => (is => 'ro', isa => 'Str');
  has TableState => (is => 'ro', isa => 'Str');
  has Updates => (is => 'ro', isa => 'Int');
  has ValidationFailedRecords => (is => 'ro', isa => 'Int');
  has ValidationPendingRecords => (is => 'ro', isa => 'Int');
  has ValidationState => (is => 'ro', isa => 'Str');
  has ValidationStateDetails => (is => 'ro', isa => 'Str');
  has ValidationSuspendedRecords => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DMS::TableStatistics

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DMS::TableStatistics object:

  $service_obj->Method(Att1 => { Ddls => $value, ..., ValidationSuspendedRecords => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DMS::TableStatistics object:

  $result = $service_obj->Method(...);
  $result->Att1->Ddls

=head1 DESCRIPTION

Provides a collection of table statistics in response to a request by
the C<DescribeTableStatistics> operation.

=head1 ATTRIBUTES


=head2 Ddls => Int

The data definition language (DDL) used to build and modify the
structure of your tables.


=head2 Deletes => Int

The number of delete actions performed on a table.


=head2 FullLoadCondtnlChkFailedRows => Int

The number of rows that failed conditional checks during the full load
operation (valid only for migrations where DynamoDB is the target).


=head2 FullLoadEndTime => Str

The time when the full load operation completed.


=head2 FullLoadErrorRows => Int

The number of rows that failed to load during the full load operation
(valid only for migrations where DynamoDB is the target).


=head2 FullLoadReloaded => Bool

A value that indicates if the table was reloaded (C<true>) or loaded as
part of a new full load operation (C<false>).


=head2 FullLoadRows => Int

The number of rows added during the full load operation.


=head2 FullLoadStartTime => Str

The time when the full load operation started.


=head2 Inserts => Int

The number of insert actions performed on a table.


=head2 LastUpdateTime => Str

The last time a table was updated.


=head2 SchemaName => Str

The schema name.


=head2 TableName => Str

The name of the table.


=head2 TableState => Str

The state of the tables described.

Valid states: Table does not exist | Before load | Full load | Table
completed | Table cancelled | Table error | Table all | Table updates |
Table is being reloaded


=head2 Updates => Int

The number of update actions performed on a table.


=head2 ValidationFailedRecords => Int

The number of records that failed validation.


=head2 ValidationPendingRecords => Int

The number of records that have yet to be validated.


=head2 ValidationState => Str

The validation state of the table.

This parameter can have the following values:

=over

=item *

Not enabled E<ndash> Validation isn't enabled for the table in the
migration task.

=item *

Pending records E<ndash> Some records in the table are waiting for
validation.

=item *

Mismatched records E<ndash> Some records in the table don't match
between the source and target.

=item *

Suspended records E<ndash> Some records in the table couldn't be
validated.

=item *

No primary key E<ndash>The table couldn't be validated because it has
no primary key.

=item *

Table error E<ndash> The table wasn't validated because it's in an
error state and some data wasn't migrated.

=item *

Validated E<ndash> All rows in the table are validated. If the table is
updated, the status can change from Validated.

=item *

Error E<ndash> The table couldn't be validated because of an unexpected
error.

=item *

Pending validation E<ndash> The table is waiting validation.

=item *

Preparing table E<ndash> Preparing the table enabled in the migration
task for validation.

=item *

Pending revalidation E<ndash> All rows in the table are pending
validation after the table was updated.

=back



=head2 ValidationStateDetails => Str

Additional details about the state of validation.


=head2 ValidationSuspendedRecords => Int

The number of records that couldn't be validated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

