# Generated by default/object.tt
package Paws::Connect::S3Config;
  use Moose;
  has BucketName => (is => 'ro', isa => 'Str', required => 1);
  has BucketPrefix => (is => 'ro', isa => 'Str', required => 1);
  has EncryptionConfig => (is => 'ro', isa => 'Paws::Connect::EncryptionConfig');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::S3Config

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::S3Config object:

  $service_obj->Method(Att1 => { BucketName => $value, ..., EncryptionConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::S3Config object:

  $result = $service_obj->Method(...);
  $result->Att1->BucketName

=head1 DESCRIPTION

Information about the Amazon Simple Storage Service (Amazon S3) storage
type.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BucketName => Str

The S3 bucket name.


=head2 B<REQUIRED> BucketPrefix => Str

The S3 bucket prefix.


=head2 EncryptionConfig => L<Paws::Connect::EncryptionConfig>

The Amazon S3 encryption configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

