# Generated by default/object.tt
package Paws::CodeGuruReviewer::RequestMetadata;
  use Moose;
  has EventInfo => (is => 'ro', isa => 'Paws::CodeGuruReviewer::EventInfo');
  has Requester => (is => 'ro', isa => 'Str');
  has RequestId => (is => 'ro', isa => 'Str');
  has VendorName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruReviewer::RequestMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruReviewer::RequestMetadata object:

  $service_obj->Method(Att1 => { EventInfo => $value, ..., VendorName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruReviewer::RequestMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->EventInfo

=head1 DESCRIPTION

Metadata that is associated with a code review. This applies to both
pull request and repository analysis code reviews.

=head1 ATTRIBUTES


=head2 EventInfo => L<Paws::CodeGuruReviewer::EventInfo>

Information about the event associated with a code review.


=head2 Requester => Str

An identifier, such as a name or account ID, that is associated with
the requester. The C<Requester> is used to capture the C<author/actor>
name of the event request.


=head2 RequestId => Str

The ID of the request. This is required for a pull request code review.


=head2 VendorName => Str

The name of the repository vendor used to upload code to an S3 bucket
for a CI/CD code review. For example, if code and artifacts are
uploaded to an S3 bucket for a CI/CD code review by GitHub scripts from
a GitHub repository, then the repository association's C<ProviderType>
is C<S3Bucket> and the CI/CD repository vendor name is GitHub. For more
information, see the definition for C<ProviderType> in
RepositoryAssociation
(https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruReviewer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

