# Generated by default/object.tt
package Paws::CodeGuruReviewer::RepositoryAssociationSummary;
  use Moose;
  has AssociationArn => (is => 'ro', isa => 'Str');
  has AssociationId => (is => 'ro', isa => 'Str');
  has ConnectionArn => (is => 'ro', isa => 'Str');
  has LastUpdatedTimeStamp => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Owner => (is => 'ro', isa => 'Str');
  has ProviderType => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruReviewer::RepositoryAssociationSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruReviewer::RepositoryAssociationSummary object:

  $service_obj->Method(Att1 => { AssociationArn => $value, ..., State => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruReviewer::RepositoryAssociationSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->AssociationArn

=head1 DESCRIPTION

Summary information about a repository association. The
C<ListRepositoryAssociations>
(https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html)
operation returns a list of C<RepositoryAssociationSummary> objects.

=head1 ATTRIBUTES


=head2 AssociationArn => Str

The Amazon Resource Name (ARN) of the C<RepositoryAssociation>
(https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociation.html)
object. You can retrieve this ARN by calling
C<ListRepositoryAssociations>
(https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_ListRepositoryAssociations.html).


=head2 AssociationId => Str

The repository association ID.


=head2 ConnectionArn => Str

The Amazon Resource Name (ARN) of an AWS CodeStar Connections
connection. Its format is
C<arn:aws:codestar-connections:region-id:aws-account_id:connection/connection-id>.
For more information, see C<Connection>
(https://docs.aws.amazon.com/codestar-connections/latest/APIReference/API_Connection.html)
in the I<AWS CodeStar Connections API Reference>.


=head2 LastUpdatedTimeStamp => Str

The time, in milliseconds since the epoch, since the repository
association was last updated.


=head2 Name => Str

The name of the repository association.


=head2 Owner => Str

The owner of the repository. For an AWS CodeCommit repository, this is
the AWS account ID of the account that owns the repository. For a
GitHub, GitHub Enterprise Server, or Bitbucket repository, this is the
username for the account that owns the repository. For an S3
repository, it can be the username or AWS account ID.


=head2 ProviderType => Str

The provider type of the repository association.


=head2 State => Str

The state of the repository association.

The valid repository association states are:

=over

=item *

B<Associated>: The repository association is complete.

=item *

B<Associating>: CodeGuru Reviewer is:

=over

=item *

Setting up pull request notifications. This is required for pull
requests to trigger a CodeGuru Reviewer review.

If your repository C<ProviderType> is C<GitHub>, C<GitHub Enterprise
Server>, or C<Bitbucket>, CodeGuru Reviewer creates webhooks in your
repository to trigger CodeGuru Reviewer reviews. If you delete these
webhooks, reviews of code in your repository cannot be triggered.

=item *

Setting up source code access. This is required for CodeGuru Reviewer
to securely clone code in your repository.

=back

=item *

B<Failed>: The repository failed to associate or disassociate.

=item *

B<Disassociating>: CodeGuru Reviewer is removing the repository's pull
request notifications and source code access.

=item *

B<Disassociated>: CodeGuru Reviewer successfully disassociated the
repository. You can create a new association with this repository if
you want to review source code in it later. You can control access to
code reviews created in an associated repository with tags after it has
been disassociated. For more information, see Using tags to control
access to associated repositories
(https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html)
in the I<Amazon CodeGuru Reviewer User Guide>.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruReviewer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

