# Generated by default/object.tt
package Paws::AutoScaling::WarmPoolConfiguration;
  use Moose;
  has MaxGroupPreparedCapacity => (is => 'ro', isa => 'Int');
  has MinSize => (is => 'ro', isa => 'Int');
  has PoolState => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AutoScaling::WarmPoolConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AutoScaling::WarmPoolConfiguration object:

  $service_obj->Method(Att1 => { MaxGroupPreparedCapacity => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AutoScaling::WarmPoolConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->MaxGroupPreparedCapacity

=head1 DESCRIPTION

Describes a warm pool configuration.

=head1 ATTRIBUTES


=head2 MaxGroupPreparedCapacity => Int

The maximum number of instances that are allowed to be in the warm pool
or in any state except C<Terminated> for the Auto Scaling group.


=head2 MinSize => Int

The minimum number of instances to maintain in the warm pool.


=head2 PoolState => Str

The instance state to transition to after the lifecycle actions are
complete.


=head2 Status => Str

The status of a warm pool that is marked for deletion.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AutoScaling>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

