# Generated by default/object.tt
package Paws::AutoScaling::Ebs;
  use Moose;
  has DeleteOnTermination => (is => 'ro', isa => 'Bool');
  has Encrypted => (is => 'ro', isa => 'Bool');
  has Iops => (is => 'ro', isa => 'Int');
  has SnapshotId => (is => 'ro', isa => 'Str');
  has Throughput => (is => 'ro', isa => 'Int');
  has VolumeSize => (is => 'ro', isa => 'Int');
  has VolumeType => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::AutoScaling::Ebs

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AutoScaling::Ebs object:

  $service_obj->Method(Att1 => { DeleteOnTermination => $value, ..., VolumeType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AutoScaling::Ebs object:

  $result = $service_obj->Method(...);
  $result->Att1->DeleteOnTermination

=head1 DESCRIPTION

Describes information used to set up an Amazon EBS volume specified in
a block device mapping.

=head1 ATTRIBUTES


=head2 DeleteOnTermination => Bool

Indicates whether the volume is deleted on instance termination. For
Amazon EC2 Auto Scaling, the default value is C<true>.


=head2 Encrypted => Bool

Specifies whether the volume should be encrypted. Encrypted EBS volumes
can only be attached to instances that support Amazon EBS encryption.
For more information, see Supported Instance Types
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances).
If your AMI uses encrypted volumes, you can also only launch it on
supported instance types.

If you are creating a volume from a snapshot, you cannot specify an
encryption value. Volumes that are created from encrypted snapshots are
automatically encrypted, and volumes that are created from unencrypted
snapshots are automatically unencrypted. By default, encrypted
snapshots use the Amazon Web Services managed CMK that is used for EBS
encryption, but you can specify a custom CMK when you create the
snapshot. The ability to encrypt a snapshot during copying also allows
you to apply a new CMK to an already-encrypted snapshot. Volumes
restored from the resulting copy are only accessible using the new CMK.

Enabling encryption by default
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default)
results in all EBS volumes being encrypted with the Amazon Web Services
managed CMK or a customer managed CMK, whether or not the snapshot was
encrypted.

For more information, see Using Encryption with EBS-Backed AMIs
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AMIEncryption.html)
in the I<Amazon EC2 User Guide for Linux Instances> and Required CMK
key policy for use with encrypted volumes
(https://docs.aws.amazon.com/autoscaling/ec2/userguide/key-policy-requirements-EBS-encryption.html)
in the I<Amazon EC2 Auto Scaling User Guide>.


=head2 Iops => Int

The number of input/output (I/O) operations per second (IOPS) to
provision for the volume. For C<gp3> and C<io1> volumes, this
represents the number of IOPS that are provisioned for the volume. For
C<gp2> volumes, this represents the baseline performance of the volume
and the rate at which the volume accumulates I/O credits for bursting.

The following are the supported values for each volume type:

=over

=item *

C<gp3>: 3,000-16,000 IOPS

=item *

C<io1>: 100-64,000 IOPS

=back

For C<io1> volumes, we guarantee 64,000 IOPS only for Instances built
on the Nitro System
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances).
Other instance families guarantee performance up to 32,000 IOPS.

C<Iops> is supported when the volume type is C<gp3> or C<io1> and
required only when the volume type is C<io1>. (Not used with
C<standard>, C<gp2>, C<st1>, or C<sc1> volumes.)


=head2 SnapshotId => Str

The snapshot ID of the volume to use.

You must specify either a C<VolumeSize> or a C<SnapshotId>.


=head2 Throughput => Int

The throughput (MiBps) to provision for a C<gp3> volume.


=head2 VolumeSize => Int

The volume size, in GiBs. The following are the supported volumes sizes
for each volume type:

=over

=item *

C<gp2> and C<gp3>: 1-16,384

=item *

C<io1>: 4-16,384

=item *

C<st1> and C<sc1>: 125-16,384

=item *

C<standard>: 1-1,024

=back

You must specify either a C<SnapshotId> or a C<VolumeSize>. If you
specify both C<SnapshotId> and C<VolumeSize>, the volume size must be
equal or greater than the size of the snapshot.


=head2 VolumeType => Str

The volume type. For more information, see Amazon EBS Volume Types
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
in the I<Amazon EC2 User Guide for Linux Instances>.

Valid Values: C<standard> | C<io1> | C<gp2> | C<st1> | C<sc1> | C<gp3>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AutoScaling>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

