# Generated by default/object.tt
package Paws::AuditManager::ServiceMetadata;
  use Moose;
  has Category => (is => 'ro', isa => 'Str', request_name => 'category', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has DisplayName => (is => 'ro', isa => 'Str', request_name => 'displayName', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::ServiceMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::ServiceMetadata object:

  $service_obj->Method(Att1 => { Category => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::ServiceMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->Category

=head1 DESCRIPTION

The metadata associated with the specified AWS service.

=head1 ATTRIBUTES


=head2 Category => Str

The category in which the AWS service belongs, such as compute,
storage, database, and so on.


=head2 Description => Str

The description of the specified AWS service.


=head2 DisplayName => Str

The display name of the AWS service.


=head2 Name => Str

The name of the AWS service.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

