# Generated by default/object.tt
package Paws::ApplicationCostProfiler::ReportDefinition;
  use Moose;
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has DestinationS3Location => (is => 'ro', isa => 'Paws::ApplicationCostProfiler::S3Location', request_name => 'destinationS3Location', traits => ['NameInRequest']);
  has Format => (is => 'ro', isa => 'Str', request_name => 'format', traits => ['NameInRequest']);
  has LastUpdatedAt => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedAt', traits => ['NameInRequest']);
  has ReportDescription => (is => 'ro', isa => 'Str', request_name => 'reportDescription', traits => ['NameInRequest']);
  has ReportFrequency => (is => 'ro', isa => 'Str', request_name => 'reportFrequency', traits => ['NameInRequest']);
  has ReportId => (is => 'ro', isa => 'Str', request_name => 'reportId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationCostProfiler::ReportDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationCostProfiler::ReportDefinition object:

  $service_obj->Method(Att1 => { CreatedAt => $value, ..., ReportId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationCostProfiler::ReportDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedAt

=head1 DESCRIPTION

The configuration of a report in AWS Application Cost Profiler.

=head1 ATTRIBUTES


=head2 CreatedAt => Str

Timestamp (milliseconds) when this report definition was created.


=head2 DestinationS3Location => L<Paws::ApplicationCostProfiler::S3Location>

The location in Amazon Simple Storage Service (Amazon S3) the reports
should be saved to.


=head2 Format => Str

The format used for the generated reports.


=head2 LastUpdatedAt => Str

Timestamp (milliseconds) when this report definition was last updated.


=head2 ReportDescription => Str

Description of the report


=head2 ReportFrequency => Str

The cadence at which the report is generated.


=head2 ReportId => Str

The ID of the report.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationCostProfiler>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

