# Generated by default/object.tt
package Paws::WorkMail::Domain;
  use Moose;
  has DomainName => (is => 'ro', isa => 'Str');
  has HostedZoneId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WorkMail::Domain

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WorkMail::Domain object:

  $service_obj->Method(Att1 => { DomainName => $value, ..., HostedZoneId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WorkMail::Domain object:

  $result = $service_obj->Method(...);
  $result->Att1->DomainName

=head1 DESCRIPTION

The domain to associate with an Amazon WorkMail organization.

When you configure a domain hosted in Amazon Route 53 (Route 53), all
recommended DNS records are added to the organization when you create
it. For more information, see Adding a domain
(https://docs.aws.amazon.com/workmail/latest/adminguide/add_domain.html)
in the I<Amazon WorkMail Administrator Guide>.

=head1 ATTRIBUTES


=head2 DomainName => Str

The fully qualified domain name.


=head2 HostedZoneId => Str

The hosted zone ID for a domain hosted in Route 53. Required when
configuring a domain hosted in Route 53.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WorkMail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

