/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.VBucketStore;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.BinaryStoreCommand;
import org.couchbase.mock.memcached.protocol.BinaryStoreResponse;
import org.couchbase.mock.memcached.protocol.CommandCode;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class StoreCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        ErrorCode err;
        BinaryStoreCommand command = (BinaryStoreCommand)cmd;
        VBucketStore cache = server.getStorage().getCache(server, cmd.getVBucketId());
        Item item = command.getItem();
        CommandCode cc = cmd.getComCode();
        switch (cc) {
            case ADD: 
            case ADDQ: {
                err = cache.add(item);
                break;
            }
            case REPLACE: 
            case REPLACEQ: {
                err = cache.replace(item);
                break;
            }
            case SET: 
            case SETQ: {
                err = cache.set(item);
                break;
            }
            default: {
                client.sendResponse(new BinaryResponse(cmd, ErrorCode.EINTERNAL));
                return;
            }
        }
        if (err == ErrorCode.SUCCESS && (cc == CommandCode.ADDQ || cc == CommandCode.SETQ || cc == CommandCode.REPLACEQ)) {
            return;
        }
        client.sendResponse(new BinaryStoreResponse(command, err, item.getCas()));
    }
}

