/* -*- mode: C; buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
 *    2008 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/opcode.pl from its data.
 * Any changes made here will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADSV_STORE	 = 10,
	OP_PADAV	 = 11,
	OP_PADHV	 = 12,
	OP_PADANY	 = 13,
	OP_RV2GV	 = 14,
	OP_RV2SV	 = 15,
	OP_AV2ARYLEN	 = 16,
	OP_RV2CV	 = 17,
	OP_ANONCODE	 = 18,
	OP_PROTOTYPE	 = 19,
	OP_REFGEN	 = 20,
	OP_SREFGEN	 = 21,
	OP_REF		 = 22,
	OP_BLESS	 = 23,
	OP_BACKTICK	 = 24,
	OP_GLOB		 = 25,
	OP_READLINE	 = 26,
	OP_RCATLINE	 = 27,
	OP_REGCMAYBE	 = 28,
	OP_REGCRESET	 = 29,
	OP_REGCOMP	 = 30,
	OP_MATCH	 = 31,
	OP_QR		 = 32,
	OP_SUBST	 = 33,
	OP_SUBSTCONT	 = 34,
	OP_TRANS	 = 35,
	OP_TRANSR	 = 36,
	OP_SASSIGN	 = 37,
	OP_AASSIGN	 = 38,
	OP_CHOP		 = 39,
	OP_SCHOP	 = 40,
	OP_CHOMP	 = 41,
	OP_SCHOMP	 = 42,
	OP_DEFINED	 = 43,
	OP_UNDEF	 = 44,
	OP_STUDY	 = 45,
	OP_POS		 = 46,
	OP_PREINC	 = 47,
	OP_I_PREINC	 = 48,
	OP_PREDEC	 = 49,
	OP_I_PREDEC	 = 50,
	OP_POSTINC	 = 51,
	OP_I_POSTINC	 = 52,
	OP_POSTDEC	 = 53,
	OP_I_POSTDEC	 = 54,
	OP_POW		 = 55,
	OP_MULTIPLY	 = 56,
	OP_I_MULTIPLY	 = 57,
	OP_DIVIDE	 = 58,
	OP_I_DIVIDE	 = 59,
	OP_MODULO	 = 60,
	OP_I_MODULO	 = 61,
	OP_REPEAT	 = 62,
	OP_ADD		 = 63,
	OP_I_ADD	 = 64,
	OP_SUBTRACT	 = 65,
	OP_I_SUBTRACT	 = 66,
	OP_CONCAT	 = 67,
	OP_MULTICONCAT	 = 68,
	OP_STRINGIFY	 = 69,
	OP_LEFT_SHIFT	 = 70,
	OP_RIGHT_SHIFT	 = 71,
	OP_LT		 = 72,
	OP_I_LT		 = 73,
	OP_GT		 = 74,
	OP_I_GT		 = 75,
	OP_LE		 = 76,
	OP_I_LE		 = 77,
	OP_GE		 = 78,
	OP_I_GE		 = 79,
	OP_EQ		 = 80,
	OP_I_EQ		 = 81,
	OP_NE		 = 82,
	OP_I_NE		 = 83,
	OP_NCMP		 = 84,
	OP_I_NCMP	 = 85,
	OP_SLT		 = 86,
	OP_SGT		 = 87,
	OP_SLE		 = 88,
	OP_SGE		 = 89,
	OP_SEQ		 = 90,
	OP_SNE		 = 91,
	OP_SCMP		 = 92,
	OP_BIT_AND	 = 93,
	OP_BIT_XOR	 = 94,
	OP_BIT_OR	 = 95,
	OP_NBIT_AND	 = 96,
	OP_NBIT_XOR	 = 97,
	OP_NBIT_OR	 = 98,
	OP_SBIT_AND	 = 99,
	OP_SBIT_XOR	 = 100,
	OP_SBIT_OR	 = 101,
	OP_NEGATE	 = 102,
	OP_I_NEGATE	 = 103,
	OP_NOT		 = 104,
	OP_COMPLEMENT	 = 105,
	OP_NCOMPLEMENT	 = 106,
	OP_SCOMPLEMENT	 = 107,
	OP_ATAN2	 = 108,
	OP_SIN		 = 109,
	OP_COS		 = 110,
	OP_RAND		 = 111,
	OP_SRAND	 = 112,
	OP_EXP		 = 113,
	OP_LOG		 = 114,
	OP_SQRT		 = 115,
	OP_INT		 = 116,
	OP_HEX		 = 117,
	OP_OCT		 = 118,
	OP_ABS		 = 119,
	OP_LENGTH	 = 120,
	OP_SUBSTR	 = 121,
	OP_VEC		 = 122,
	OP_INDEX	 = 123,
	OP_RINDEX	 = 124,
	OP_SPRINTF	 = 125,
	OP_FORMLINE	 = 126,
	OP_ORD		 = 127,
	OP_CHR		 = 128,
	OP_CRYPT	 = 129,
	OP_UCFIRST	 = 130,
	OP_LCFIRST	 = 131,
	OP_UC		 = 132,
	OP_LC		 = 133,
	OP_QUOTEMETA	 = 134,
	OP_RV2AV	 = 135,
	OP_AELEMFAST	 = 136,
	OP_AELEMFAST_LEX = 137,
	OP_AELEMFASTLEX_STORE = 138,
	OP_AELEM	 = 139,
	OP_ASLICE	 = 140,
	OP_KVASLICE	 = 141,
	OP_AEACH	 = 142,
	OP_AVALUES	 = 143,
	OP_AKEYS	 = 144,
	OP_EACH		 = 145,
	OP_VALUES	 = 146,
	OP_KEYS		 = 147,
	OP_DELETE	 = 148,
	OP_EXISTS	 = 149,
	OP_RV2HV	 = 150,
	OP_HELEM	 = 151,
	OP_HSLICE	 = 152,
	OP_KVHSLICE	 = 153,
	OP_MULTIDEREF	 = 154,
	OP_UNPACK	 = 155,
	OP_PACK		 = 156,
	OP_SPLIT	 = 157,
	OP_JOIN		 = 158,
	OP_LIST		 = 159,
	OP_LSLICE	 = 160,
	OP_ANONLIST	 = 161,
	OP_ANONHASH	 = 162,
	OP_EMPTYAVHV	 = 163,
	OP_SPLICE	 = 164,
	OP_PUSH		 = 165,
	OP_POP		 = 166,
	OP_SHIFT	 = 167,
	OP_UNSHIFT	 = 168,
	OP_SORT		 = 169,
	OP_REVERSE	 = 170,
	OP_GREPSTART	 = 171,
	OP_GREPWHILE	 = 172,
	OP_MAPSTART	 = 173,
	OP_MAPWHILE	 = 174,
	OP_RANGE	 = 175,
	OP_FLIP		 = 176,
	OP_FLOP		 = 177,
	OP_AND		 = 178,
	OP_OR		 = 179,
	OP_XOR		 = 180,
	OP_DOR		 = 181,
	OP_COND_EXPR	 = 182,
	OP_ANDASSIGN	 = 183,
	OP_ORASSIGN	 = 184,
	OP_DORASSIGN	 = 185,
	OP_ENTERSUB	 = 186,
	OP_LEAVESUB	 = 187,
	OP_LEAVESUBLV	 = 188,
	OP_ARGCHECK	 = 189,
	OP_ARGELEM	 = 190,
	OP_ARGDEFELEM	 = 191,
	OP_CALLER	 = 192,
	OP_WARN		 = 193,
	OP_DIE		 = 194,
	OP_RESET	 = 195,
	OP_LINESEQ	 = 196,
	OP_NEXTSTATE	 = 197,
	OP_DBSTATE	 = 198,
	OP_UNSTACK	 = 199,
	OP_ENTER	 = 200,
	OP_LEAVE	 = 201,
	OP_SCOPE	 = 202,
	OP_ENTERITER	 = 203,
	OP_ITER		 = 204,
	OP_ENTERLOOP	 = 205,
	OP_LEAVELOOP	 = 206,
	OP_RETURN	 = 207,
	OP_LAST		 = 208,
	OP_NEXT		 = 209,
	OP_REDO		 = 210,
	OP_DUMP		 = 211,
	OP_GOTO		 = 212,
	OP_EXIT		 = 213,
	OP_METHOD	 = 214,
	OP_METHOD_NAMED	 = 215,
	OP_METHOD_SUPER	 = 216,
	OP_METHOD_REDIR	 = 217,
	OP_METHOD_REDIR_SUPER = 218,
	OP_OPEN		 = 219,
	OP_CLOSE	 = 220,
	OP_PIPE_OP	 = 221,
	OP_FILENO	 = 222,
	OP_UMASK	 = 223,
	OP_BINMODE	 = 224,
	OP_TIE		 = 225,
	OP_UNTIE	 = 226,
	OP_TIED		 = 227,
	OP_DBMOPEN	 = 228,
	OP_DBMCLOSE	 = 229,
	OP_SSELECT	 = 230,
	OP_SELECT	 = 231,
	OP_GETC		 = 232,
	OP_READ		 = 233,
	OP_ENTERWRITE	 = 234,
	OP_LEAVEWRITE	 = 235,
	OP_PRTF		 = 236,
	OP_PRINT	 = 237,
	OP_SAY		 = 238,
	OP_SYSOPEN	 = 239,
	OP_SYSSEEK	 = 240,
	OP_SYSREAD	 = 241,
	OP_SYSWRITE	 = 242,
	OP_EOF		 = 243,
	OP_TELL		 = 244,
	OP_SEEK		 = 245,
	OP_TRUNCATE	 = 246,
	OP_FCNTL	 = 247,
	OP_IOCTL	 = 248,
	OP_FLOCK	 = 249,
	OP_SEND		 = 250,
	OP_RECV		 = 251,
	OP_SOCKET	 = 252,
	OP_SOCKPAIR	 = 253,
	OP_BIND		 = 254,
	OP_CONNECT	 = 255,
	OP_LISTEN	 = 256,
	OP_ACCEPT	 = 257,
	OP_SHUTDOWN	 = 258,
	OP_GSOCKOPT	 = 259,
	OP_SSOCKOPT	 = 260,
	OP_GETSOCKNAME	 = 261,
	OP_GETPEERNAME	 = 262,
	OP_LSTAT	 = 263,
	OP_STAT		 = 264,
	OP_FTRREAD	 = 265,
	OP_FTRWRITE	 = 266,
	OP_FTREXEC	 = 267,
	OP_FTEREAD	 = 268,
	OP_FTEWRITE	 = 269,
	OP_FTEEXEC	 = 270,
	OP_FTIS		 = 271,
	OP_FTSIZE	 = 272,
	OP_FTMTIME	 = 273,
	OP_FTATIME	 = 274,
	OP_FTCTIME	 = 275,
	OP_FTROWNED	 = 276,
	OP_FTEOWNED	 = 277,
	OP_FTZERO	 = 278,
	OP_FTSOCK	 = 279,
	OP_FTCHR	 = 280,
	OP_FTBLK	 = 281,
	OP_FTFILE	 = 282,
	OP_FTDIR	 = 283,
	OP_FTPIPE	 = 284,
	OP_FTSUID	 = 285,
	OP_FTSGID	 = 286,
	OP_FTSVTX	 = 287,
	OP_FTLINK	 = 288,
	OP_FTTTY	 = 289,
	OP_FTTEXT	 = 290,
	OP_FTBINARY	 = 291,
	OP_CHDIR	 = 292,
	OP_CHOWN	 = 293,
	OP_CHROOT	 = 294,
	OP_UNLINK	 = 295,
	OP_CHMOD	 = 296,
	OP_UTIME	 = 297,
	OP_RENAME	 = 298,
	OP_LINK		 = 299,
	OP_SYMLINK	 = 300,
	OP_READLINK	 = 301,
	OP_MKDIR	 = 302,
	OP_RMDIR	 = 303,
	OP_OPEN_DIR	 = 304,
	OP_READDIR	 = 305,
	OP_TELLDIR	 = 306,
	OP_SEEKDIR	 = 307,
	OP_REWINDDIR	 = 308,
	OP_CLOSEDIR	 = 309,
	OP_FORK		 = 310,
	OP_WAIT		 = 311,
	OP_WAITPID	 = 312,
	OP_SYSTEM	 = 313,
	OP_EXEC		 = 314,
	OP_KILL		 = 315,
	OP_GETPPID	 = 316,
	OP_GETPGRP	 = 317,
	OP_SETPGRP	 = 318,
	OP_GETPRIORITY	 = 319,
	OP_SETPRIORITY	 = 320,
	OP_TIME		 = 321,
	OP_TMS		 = 322,
	OP_LOCALTIME	 = 323,
	OP_GMTIME	 = 324,
	OP_ALARM	 = 325,
	OP_SLEEP	 = 326,
	OP_SHMGET	 = 327,
	OP_SHMCTL	 = 328,
	OP_SHMREAD	 = 329,
	OP_SHMWRITE	 = 330,
	OP_MSGGET	 = 331,
	OP_MSGCTL	 = 332,
	OP_MSGSND	 = 333,
	OP_MSGRCV	 = 334,
	OP_SEMOP	 = 335,
	OP_SEMGET	 = 336,
	OP_SEMCTL	 = 337,
	OP_REQUIRE	 = 338,
	OP_DOFILE	 = 339,
	OP_HINTSEVAL	 = 340,
	OP_ENTEREVAL	 = 341,
	OP_LEAVEEVAL	 = 342,
	OP_ENTERTRY	 = 343,
	OP_LEAVETRY	 = 344,
	OP_GHBYNAME	 = 345,
	OP_GHBYADDR	 = 346,
	OP_GHOSTENT	 = 347,
	OP_GNBYNAME	 = 348,
	OP_GNBYADDR	 = 349,
	OP_GNETENT	 = 350,
	OP_GPBYNAME	 = 351,
	OP_GPBYNUMBER	 = 352,
	OP_GPROTOENT	 = 353,
	OP_GSBYNAME	 = 354,
	OP_GSBYPORT	 = 355,
	OP_GSERVENT	 = 356,
	OP_SHOSTENT	 = 357,
	OP_SNETENT	 = 358,
	OP_SPROTOENT	 = 359,
	OP_SSERVENT	 = 360,
	OP_EHOSTENT	 = 361,
	OP_ENETENT	 = 362,
	OP_EPROTOENT	 = 363,
	OP_ESERVENT	 = 364,
	OP_GPWNAM	 = 365,
	OP_GPWUID	 = 366,
	OP_GPWENT	 = 367,
	OP_SPWENT	 = 368,
	OP_EPWENT	 = 369,
	OP_GGRNAM	 = 370,
	OP_GGRGID	 = 371,
	OP_GGRENT	 = 372,
	OP_SGRENT	 = 373,
	OP_EGRENT	 = 374,
	OP_GETLOGIN	 = 375,
	OP_SYSCALL	 = 376,
	OP_LOCK		 = 377,
	OP_ONCE		 = 378,
	OP_CUSTOM	 = 379,
	OP_COREARGS	 = 380,
	OP_AVHVSWITCH	 = 381,
	OP_RUNCV	 = 382,
	OP_FC		 = 383,
	OP_PADCV	 = 384,
	OP_INTROCV	 = 385,
	OP_CLONECV	 = 386,
	OP_PADRANGE	 = 387,
	OP_REFASSIGN	 = 388,
	OP_LVREF	 = 389,
	OP_LVREFSLICE	 = 390,
	OP_LVAVREF	 = 391,
	OP_ANONCONST	 = 392,
	OP_ISA		 = 393,
	OP_CMPCHAIN_AND	 = 394,
	OP_CMPCHAIN_DUP	 = 395,
	OP_ENTERTRYCATCH = 396,
	OP_LEAVETRYCATCH = 397,
	OP_POPTRY	 = 398,
	OP_CATCH	 = 399,
	OP_PUSHDEFER	 = 400,
	OP_IS_BOOL	 = 401,
	OP_IS_WEAK	 = 402,
	OP_WEAKEN	 = 403,
	OP_UNWEAKEN	 = 404,
	OP_BLESSED	 = 405,
	OP_REFADDR	 = 406,
	OP_REFTYPE	 = 407,
	OP_CEIL		 = 408,
	OP_FLOOR	 = 409,
	OP_IS_TAINTED	 = 410,
	OP_HELEMEXISTSOR = 411,
	OP_METHSTART	 = 412,
	OP_INITFIELD	 = 413,
	OP_CLASSNAME	 = 414,
	OP_max		
} opcode;

/*
=for apidoc Ay||opcode
An enum of all the legal Perl opcodes, defined in F<opnames.h>

=cut
*/

#define MAXO 415
#define OP_FREED MAXO

/* the OP_IS_* macros are optimized to a simple range check because
    all the member OPs are contiguous in regen/opcodes table.
    opcode.pl verifies the range contiguity, or generates an OR-equals
    expression */

#define OP_IS_SOCKET(op)   \
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)   \
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)   \
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

#define OP_IS_NUMCOMPARE(op)   \
	((op) >= OP_LT && (op) <= OP_I_NCMP)

#define OP_IS_DIRHOP(op)   \
	((op) >= OP_READDIR && (op) <= OP_CLOSEDIR)

#define OP_IS_INFIX_BIT(op)   \
	((op) >= OP_BIT_AND && (op) <= OP_SBIT_OR)

/* ex: set ro ft=c: */
