/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_data_Node({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":["Ext.tree.TreeNode"],"extends":"Ext.util.Observable","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='docClass'>Ext.util.Observable</a><div class='subclass '><strong>Ext.data.Node</strong></div></div><h4>Subclasses</h4><div class='dependency'><a href='#!/api/Ext.tree.TreeNode' rel='Ext.tree.TreeNode' class='docClass'>Ext.tree.TreeNode</a></div><h4>Files</h4><div class='dependency'><a href='source/Tree.html#Ext-data-Node' target='_blank'>Tree.js</a></div></pre><div class='doc-contents'>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-id' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-cfg-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-cfg-id' class='name expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'>The id for this node. ...</div><div class='long'><p>The id for this node. If one is not specified, one is generated.</p>\n</div></div></div><div id='cfg-leaf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-cfg-leaf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-cfg-leaf' class='name not-expandable'>leaf</a><span> : Boolean</span></div><div class='description'><div class='short'><p>true if this node is a leaf and does not have children</p>\n</div><div class='long'><p>true if this node is a leaf and does not have children</p>\n</div></div></div><div id='cfg-listeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-cfg-listeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-cfg-listeners' class='name expandable'>listeners</a><span> : Object</span></div><div class='description'><div class='short'>(optional) A config object containing one or more event handlers to be added to this\nobject during initialization. ...</div><div class='long'><p>(optional) <p>A config object containing one or more event handlers to be added to this\nobject during initialization.  This should be a valid listeners config object as specified in the\n<a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> example for attaching multiple handlers at once.</p></p>\n\n<br><p><b><u>DOM events from ExtJs <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Components</a></u></b></p>\n\n\n<br><p>While <i>some</i> ExtJs Component classes export selected DOM events (e.g. \"click\", \"mouseover\" etc), this\n\n\n<p>is usually only done when extra value can be added. For example the <a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">DataView</a>'s\n<b><code><a href=\"#!/api/Ext.DataView-event-click\" rel=\"Ext.DataView-event-click\" class=\"docClass\">click</a></code></b> event passing the node clicked on. To access DOM\nevents directly from a Component's HTMLElement, listeners must be added to the <i><a href=\"#!/api/Ext.Component-method-getEl\" rel=\"Ext.Component-method-getEl\" class=\"docClass\">Element</a></i> after the Component\nhas been rendered. A plugin can simplify this step:</p>\n\n<pre><code>// Plugin is configured with a listeners config object.\n// The Component is appended to the argument list of all handler functions.\nExt.DomObserver = <a href=\"#!/api/Ext-method-extend\" rel=\"Ext-method-extend\" class=\"docClass\">Ext.extend</a>(Object, {\n    constructor: function(config) {\n        this.listeners = config.listeners ? config.listeners : config;\n    },\n\n    // Component passes itself into plugin&#39;s init method\n    init: function(c) {\n        var p, l = this.listeners;\n        for (p in l) {\n            if (<a href=\"#!/api/Ext-method-isFunction\" rel=\"Ext-method-isFunction\" class=\"docClass\">Ext.isFunction</a>(l[p])) {\n                l[p] = this.createHandler(l[p], c);\n            } else {\n                l[p].fn = this.createHandler(l[p].fn, c);\n            }\n        }\n\n        // Add the listeners to the Element immediately following the render call\n        c.render = c.render.<a href=\"#!/api/Function-method-createSequence\" rel=\"Function-method-createSequence\" class=\"docClass\">createSequence</a>(function() {\n            var e = c.getEl();\n            if (e) {\n                e.on(l);\n            }\n        });\n    },\n\n    createHandler: function(fn, c) {\n        return function(e) {\n            fn.call(this, e, c);\n        };\n    }\n});\n\nvar combo = new <a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a>({\n\n    // Collapse combo when its element is clicked on\n    plugins: [ new Ext.DomObserver({\n        click: function(evt, comp) {\n            comp.collapse();\n        }\n    })],\n    store: myStore,\n    typeAhead: true,\n    mode: 'local',\n    triggerAction: 'all'\n});\n</code></pre>\n\n\n<p></p></p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-attributes' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-property-attributes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-property-attributes' class='name expandable'>attributes</a><span> : Object</span></div><div class='description'><div class='short'>The attributes supplied for the node. ...</div><div class='long'><p>The attributes supplied for the node. You can use this property to access any custom attributes you supplied.</p>\n</div></div></div><div id='property-childNodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-property-childNodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-property-childNodes' class='name expandable'>childNodes</a><span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a></span></div><div class='description'><div class='short'>All child nodes of this node. ...</div><div class='long'><p>All child nodes of this node.</p>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-firstChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-property-firstChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-property-firstChild' class='name not-expandable'>firstChild</a><span> : Node</span></div><div class='description'><div class='short'><p>The first direct child node of this node, or null if this node has no child nodes.</p>\n</div><div class='long'><p>The first direct child node of this node, or null if this node has no child nodes.</p>\n</div></div></div><div id='property-id' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-property-id' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-property-id' class='name not-expandable'>id</a><span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span></div><div class='description'><div class='short'><p>The node id.</p>\n</div><div class='long'><p>The node id.</p>\n</div></div></div><div id='property-lastChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-property-lastChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-property-lastChild' class='name not-expandable'>lastChild</a><span> : Node</span></div><div class='description'><div class='short'><p>The last direct child node of this node, or null if this node has no child nodes.</p>\n</div><div class='long'><p>The last direct child node of this node, or null if this node has no child nodes.</p>\n</div></div></div><div id='property-nextSibling' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-property-nextSibling' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-property-nextSibling' class='name not-expandable'>nextSibling</a><span> : Node</span></div><div class='description'><div class='short'><p>The node immediately following this node in the tree, or null if there is no sibling node.</p>\n</div><div class='long'><p>The node immediately following this node in the tree, or null if there is no sibling node.</p>\n</div></div></div><div id='property-parentNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-property-parentNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-property-parentNode' class='name not-expandable'>parentNode</a><span> : Node</span></div><div class='description'><div class='short'><p>The parent node for this node.</p>\n</div><div class='long'><p>The parent node for this node.</p>\n</div></div></div><div id='property-previousSibling' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-property-previousSibling' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-property-previousSibling' class='name not-expandable'>previousSibling</a><span> : Node</span></div><div class='description'><div class='short'><p>The node immediately preceding this node in the tree, or null if there is no sibling node.</p>\n</div><div class='long'><p>The node immediately preceding this node in the tree, or null if there is no sibling node.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.data.Node-method-constructor' class='name expandable'>Ext.data.Node</a>( <span class='pre'>attributes</span> ) : <a href=\"#!/api/Ext.data.Node\" rel=\"Ext.data.Node\" class=\"docClass\">Ext.data.Node</a></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>attributes</span> : Object<div class='sub-desc'><p>The attributes/config for the node</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.data.Node\" rel=\"Ext.data.Node\" class=\"docClass\">Ext.data.Node</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-addEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addEvents' class='name expandable'>addEvents</a>( <span class='pre'>o, Optional</span> )</div><div class='description'><div class='short'>Adds the specified events to the list of events which this Observable may fire. ...</div><div class='long'><p>Adds the specified events to the list of events which this Observable may fire.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object|<a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>Either an object with event names as properties with a value of <code>true</code>\nor the first event name string if multiple event names are being passed as separate parameters.</p>\n</div></li><li><span class='pre'>Optional</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">string</a><div class='sub-desc'><p>. Event name if multiple event names are being passed as separate parameters.\nUsage:</p>\n\n<pre><code>this.addEvents('storeloaded', 'storecleared');\n</code></pre>\n\n</div></li></ul></div></div></div><div id='method-addListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-addListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-addListener' class='name expandable'>addListener</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object. ...</div><div class='long'><p>Appends an event handler to this object.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to listen for.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.\nproperties. This may contain any of the following properties:<ul>\n<li><b>scope</b> : Object<div class=\"sub-desc\">The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></div></li>\n<li><b>delay</b> : Number<div class=\"sub-desc\">The number of milliseconds to delay the invocation of the handler after the event fires.</div></li>\n<li><b>single</b> : Boolean<div class=\"sub-desc\">True to add a handler to handle just the next firing of the event, and then remove itself.</div></li>\n<li><b>buffer</b> : Number<div class=\"sub-desc\">Causes the handler to be scheduled to run in an <a href=\"#!/api/Ext.util.DelayedTask\" rel=\"Ext.util.DelayedTask\" class=\"docClass\">Ext.util.DelayedTask</a> delayed\nby the specified number of milliseconds. If the event fires again within that time, the original\nhandler is <em>not</em> invoked, but the new handler is scheduled in its place.</div></li>\n<li><b>target</b> : Observable<div class=\"sub-desc\">Only call the handler if the event was fired on the target Observable, <i>not</i>\nif the event was bubbled up from a child Observable.</div></li>\n</ul><br></p>\n\n<p>\n<b>Combining Options</b><br>\nUsing the options argument, it is possible to combine different types of listeners:<br>\n<br>\nA delayed, one-time listener.\n<pre><code>myDataView.on('click', this.onClick, this, {\nsingle: true,\ndelay: 100\n});</code></pre>\n<p>\n<b>Attaching multiple handlers in 1 call</b><br>\nThe method also allows for a single argument to be passed which is a config object containing properties\nwhich specify multiple handlers.\n<p>\n<pre><code>myGridPanel.on({\n'click' : {\n    fn: this.onClick,\n    scope: this,\n    delay: 100\n},\n'mouseover' : {\n    fn: this.onMouseOver,\n    scope: this\n},\n'mouseout' : {\n    fn: this.onMouseOut,\n    scope: this\n}\n});</code></pre>\n<p>\nOr a shorthand syntax:<br>\n<pre><code>myGridPanel.on({\n'click' : this.onClick,\n'mouseover' : this.onMouseOver,\n'mouseout' : this.onMouseOut,\n scope: this\n});</code></pre>\n\n</p></p></p></p></div></li></ul></div></div></div><div id='method-appendChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-appendChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-appendChild' class='name expandable'>appendChild</a>( <span class='pre'>node</span> ) : Node</div><div class='description'><div class='short'>Insert node(s) as the last child node of this node. ...</div><div class='long'><p>Insert node(s) as the last child node of this node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : Node/Array<div class='sub-desc'><p>The node or Array of nodes to append</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Node</span><div class='sub-desc'><p>The appended node if single append, or null if an array was passed</p>\n</div></li></ul></div></div></div><div id='method-bubble' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-bubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-bubble' class='name expandable'>bubble</a>( <span class='pre'>fn, [scope], [args]</span> )</div><div class='description'><div class='short'>Bubbles up the tree from this node, calling the specified function with each node. ...</div><div class='long'><p>Bubbles up the tree from this node, calling the specified function with each node. The arguments to the function\nwill be the args provided or the current node. If the function returns false at any point,\nthe bubble is stopped.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to the current Node.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The args to call the function with (default to passing the current Node)</p>\n</div></li></ul></div></div></div><div id='method-cascade' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-cascade' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-cascade' class='name expandable'>cascade</a>( <span class='pre'>fn, [scope], [args]</span> )</div><div class='description'><div class='short'>Cascades down the tree from this node, calling the specified function with each node. ...</div><div class='long'><p>Cascades down the tree from this node, calling the specified function with each node. The arguments to the function\nwill be the args provided or the current node. If the function returns false at any point,\nthe cascade is stopped on that branch.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to the current Node.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The args to call the function with (default to passing the current Node)</p>\n</div></li></ul></div></div></div><div id='method-clear' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-clear' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-clear' class='name expandable'>clear</a>( <span class='pre'>destroy</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>destroy</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-contains' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-contains' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-contains' class='name expandable'>contains</a>( <span class='pre'>node</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this node is an ancestor (at any point) of the passed node. ...</div><div class='long'><p>Returns true if this node is an ancestor (at any point) of the passed node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : Node<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-destroy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-destroy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-destroy' class='name expandable'>destroy</a>( <span class='pre'>silent</span> )</div><div class='description'><div class='short'>Destroys the node. ...</div><div class='long'><p>Destroys the node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>silent</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-eachChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-eachChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-eachChild' class='name expandable'>eachChild</a>( <span class='pre'>fn, [scope], [args]</span> )</div><div class='description'><div class='short'>Interates the child nodes of this node, calling the specified function with each node. ...</div><div class='long'><p>Interates the child nodes of this node, calling the specified function with each node. The arguments to the function\nwill be the args provided or the current node. If the function returns false at any point,\nthe iteration stops.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The function to call</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to the current Node in the iteration.</p>\n</div></li><li><span class='pre'>args</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a> (optional)<div class='sub-desc'><p>The args to call the function with (default to passing the current Node)</p>\n</div></li></ul></div></div></div><div id='method-enableBubble' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-enableBubble' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-enableBubble' class='name expandable'>enableBubble</a>( <span class='pre'>events</span> )</div><div class='description'><div class='short'>Enables events fired by this Observable to bubble up an owner hierarchy by calling\nthis.getBubbleTarget() if present. ...</div><div class='long'><p>Enables events fired by this Observable to bubble up an owner hierarchy by calling\n<code>this.getBubbleTarget()</code> if present. There is no implementation in the Observable base class.</p>\n\n\n<p>This is commonly used by Ext.Components to bubble events to owner Containers. See Ext.Component.getBubbleTarget. The default\nimplementation in <a href=\"#!/api/Ext.Component\" rel=\"Ext.Component\" class=\"docClass\">Ext.Component</a> returns the Component's immediate owner. But if a known target is required, this can be overridden to\naccess the required target more quickly.</p>\n\n\n<p>Example:</p>\n\n\n<pre><code><a href=\"#!/api/Ext-method-override\" rel=\"Ext-method-override\" class=\"docClass\">Ext.override</a>(<a href=\"#!/api/Ext.form.Field\" rel=\"Ext.form.Field\" class=\"docClass\">Ext.form.Field</a>, {\n    //  Add functionality to Field&#39;s initComponent to enable the change event to bubble\n    initComponent : Ext.form.Field.prototype.initComponent.createSequence(function() {\n        this.enableBubble('change');\n    }),\n\n    //  We know that we want Field&#39;s events to bubble directly to the FormPanel.\n    getBubbleTarget : function() {\n        if (!this.formPanel) {\n            this.formPanel = this.findParentByType('form');\n        }\n        return this.formPanel;\n    }\n});\n\nvar myForm = new Ext.formPanel({\n    title: 'User Details',\n    items: [{\n        ...\n    }],\n    listeners: {\n        change: function() {\n            // Title goes red if form has been modified.\n            myForm.header.setStyle('color', 'red');\n        }\n    }\n});\n</code></pre>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>events</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The event name to bubble, or an Array of event names.</p>\n</div></li></ul></div></div></div><div id='method-findChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-findChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-findChild' class='name expandable'>findChild</a>( <span class='pre'>attribute, value, [deep]</span> ) : Node</div><div class='description'><div class='short'>Finds the first child that has the attribute with the specified value. ...</div><div class='long'><p>Finds the first child that has the attribute with the specified value.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>attribute</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The attribute name</p>\n</div></li><li><span class='pre'>value</span> : Mixed<div class='sub-desc'><p>The value to search for</p>\n</div></li><li><span class='pre'>deep</span> : Boolean (optional)<div class='sub-desc'><p>True to search through nodes deeper than the immediate children</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Node</span><div class='sub-desc'><p>The found child or null if none was found</p>\n</div></li></ul></div></div></div><div id='method-findChildBy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-findChildBy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-findChildBy' class='name expandable'>findChildBy</a>( <span class='pre'>fn, [scope], [deep]</span> ) : Node</div><div class='description'><div class='short'>Finds the first child by a custom function. ...</div><div class='long'><p>Finds the first child by a custom function. The child matches if the function passed returns <code>true</code>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>A function which must return <code>true</code> if the passed Node is the required Node.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to the Node being tested.</p>\n</div></li><li><span class='pre'>deep</span> : Boolean (optional)<div class='sub-desc'><p>True to search through nodes deeper than the immediate children</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Node</span><div class='sub-desc'><p>The found child or null if none was found</p>\n</div></li></ul></div></div></div><div id='method-fireEvent' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-fireEvent' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-fireEvent' class='name expandable'>fireEvent</a>( <span class='pre'>eventName, args</span> ) : Boolean</div><div class='description'><div class='short'>private\n\nFires the specified event with the passed parameters (minus the event name). ...</div><div class='long'><p>private</p>\n\n<p>Fires the specified event with the passed parameters (minus the event name).</p>\n\n\n<p>An event may be set to bubble up an Observable parent hierarchy (See <a href=\"#!/api/Ext.Component-method-getBubbleTarget\" rel=\"Ext.Component-method-getBubbleTarget\" class=\"docClass\">Ext.Component.getBubbleTarget</a>)\nby calling <a href=\"#!/api/Ext.data.Node-method-enableBubble\" rel=\"Ext.data.Node-method-enableBubble\" class=\"docClass\">enableBubble</a>.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to fire.</p>\n</div></li><li><span class='pre'>args</span> : Object...<div class='sub-desc'><p>Variable number of parameters are passed to handlers.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>returns false if any of the handlers return false otherwise it returns true.</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.util.Observable-method-fireEvent' rel='Ext.util.Observable-method-fireEvent' class='docClass'>Ext.util.Observable.fireEvent</a></p></div></div></div><div id='method-getDepth' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-getDepth' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-getDepth' class='name expandable'>getDepth</a>( <span class='pre'></span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns depth of this node (the root node has a depth of 0) ...</div><div class='long'><p>Returns depth of this node (the root node has a depth of 0)</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getOwnerTree' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-getOwnerTree' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-getOwnerTree' class='name expandable'>getOwnerTree</a>( <span class='pre'></span> ) : Tree</div><div class='description'><div class='short'>Returns the tree this node is in. ...</div><div class='long'><p>Returns the tree this node is in.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Tree</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getPath' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-getPath' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-getPath' class='name expandable'>getPath</a>( <span class='pre'>[attr]</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns the path for this node. ...</div><div class='long'><p>Returns the path for this node. The path can be used to expand or select this node programmatically.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>attr</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a> (optional)<div class='sub-desc'><p>The attr to use for the path (defaults to the node's id)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The path</p>\n</div></li></ul></div></div></div><div id='method-hasChildNodes' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-hasChildNodes' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-hasChildNodes' class='name expandable'>hasChildNodes</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this node has one or more child nodes, else false. ...</div><div class='long'><p>Returns true if this node has one or more child nodes, else false.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-hasListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-hasListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-hasListener' class='name expandable'>hasListener</a>( <span class='pre'>eventName</span> ) : Boolean</div><div class='description'><div class='short'>Checks to see if this object has any listeners for a specified event ...</div><div class='long'><p>Checks to see if this object has any listeners for a specified event</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The name of the event to check for</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'><p>True if the event is being listened for, else false</p>\n</div></li></ul></div></div></div><div id='method-indexOf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-indexOf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-indexOf' class='name expandable'>indexOf</a>( <span class='pre'>node</span> ) : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></div><div class='description'><div class='short'>Returns the index of a child node ...</div><div class='long'><p>Returns the index of a child node</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : Node<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a></span><div class='sub-desc'><p>The index of the node or -1 if it was not found</p>\n</div></li></ul></div></div></div><div id='method-insertBefore' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-insertBefore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-insertBefore' class='name expandable'>insertBefore</a>( <span class='pre'>node, refNode</span> ) : Node</div><div class='description'><div class='short'>Inserts the first node before the second node in this nodes childNodes collection. ...</div><div class='long'><p>Inserts the first node before the second node in this nodes childNodes collection.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : Node<div class='sub-desc'><p>The node to insert</p>\n</div></li><li><span class='pre'>refNode</span> : Node<div class='sub-desc'><p>The node to insert before (if null the node is appended)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Node</span><div class='sub-desc'><p>The inserted node</p>\n</div></li></ul></div></div></div><div id='method-isAncestor' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-isAncestor' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-isAncestor' class='name expandable'>isAncestor</a>( <span class='pre'>node</span> ) : Boolean</div><div class='description'><div class='short'>Returns true if the passed node is an ancestor (at any point) of this node. ...</div><div class='long'><p>Returns true if the passed node is an ancestor (at any point) of this node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : Node<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isExpandable' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-isExpandable' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-isExpandable' class='name expandable'>isExpandable</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this node has one or more child nodes, or if the expandable\nnode attribute is explicitly specified as...</div><div class='long'><p>Returns true if this node has one or more child nodes, or if the <tt>expandable</tt>\nnode attribute is explicitly specified as true (see <a href=\"#!/api/Ext.data.Node-property-attributes\" rel=\"Ext.data.Node-property-attributes\" class=\"docClass\">attributes</a>), otherwise returns false.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isFirst' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-isFirst' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-isFirst' class='name expandable'>isFirst</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this node is the first child of its parent ...</div><div class='long'><p>Returns true if this node is the first child of its parent</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isLast' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-isLast' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-isLast' class='name expandable'>isLast</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this node is the last child of its parent ...</div><div class='long'><p>Returns true if this node is the last child of its parent</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isLeaf' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-isLeaf' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-isLeaf' class='name expandable'>isLeaf</a>( <span class='pre'></span> ) : Boolean</div><div class='description'><div class='short'>Returns true if this node is a leaf ...</div><div class='long'><p>Returns true if this node is a leaf</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-item' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-item' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-item' class='name expandable'>item</a>( <span class='pre'>index</span> ) : Node</div><div class='description'><div class='short'>Returns the child node at the specified index. ...</div><div class='long'><p>Returns the child node at the specified index.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Node</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-on' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-on' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-on' class='name expandable'>on</a>( <span class='pre'>eventName, handler, [scope], [options]</span> )</div><div class='description'><div class='short'>Appends an event handler to this object (shorthand for addListener.) ...</div><div class='long'><p>Appends an event handler to this object (shorthand for <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event to listen for</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The method the event invokes</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code><b>this</b></code> reference) in which the handler function is executed.\n<b>If omitted, defaults to the object which fired the event.</b></p>\n</div></li><li><span class='pre'>options</span> : Object (optional)<div class='sub-desc'><p>An object containing handler configuration.</p>\n</div></li></ul></div></div></div><div id='method-onIdChange' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-onIdChange' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-onIdChange' class='name expandable'>onIdChange</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n</div></div></div><div id='method-purgeListeners' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-purgeListeners' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-purgeListeners' class='name expandable'>purgeListeners</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Removes all listeners for this object ...</div><div class='long'><p>Removes all listeners for this object</p>\n</div></div></div><div id='method-relayEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable-more.html#Ext-util-Observable-method-relayEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-relayEvents' class='name expandable'>relayEvents</a>( <span class='pre'>o, events</span> )</div><div class='description'><div class='short'>Relays selected events from the specified Observable as if the events were fired by this. ...</div><div class='long'><p>Relays selected events from the specified Observable as if the events were fired by <tt><b>this</b></tt>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>o</span> : Object<div class='sub-desc'><p>The Observable whose events this object is to relay.</p>\n</div></li><li><span class='pre'>events</span> : <a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>Array of event names to relay.</p>\n</div></li></ul></div></div></div><div id='method-remove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-remove' class='name expandable'>remove</a>( <span class='pre'>destroy</span> ) : Node<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Removes this node from its parent ...</div><div class='long'><p>Removes this node from its parent</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>destroy</span> : Boolean<div class='sub-desc'><p><tt>true</tt> to destroy the node upon removal. Defaults to <tt>false</tt>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Node</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeAll' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-removeAll' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-removeAll' class='name expandable'>removeAll</a>( <span class='pre'>destroy</span> ) : Node<strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Removes all child nodes from this node. ...</div><div class='long'><p>Removes all child nodes from this node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>destroy</span> : Boolean<div class='sub-desc'><p><tt>true</tt> to destroy the node upon removal. Defaults to <tt>false</tt>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Node</span><div class='sub-desc'><p>this</p>\n</div></li></ul></div></div></div><div id='method-removeChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-removeChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-removeChild' class='name expandable'>removeChild</a>( <span class='pre'>node, destroy</span> ) : Node</div><div class='description'><div class='short'>Removes a child node from this node. ...</div><div class='long'><p>Removes a child node from this node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : Node<div class='sub-desc'><p>The node to remove</p>\n</div></li><li><span class='pre'>destroy</span> : Boolean<div class='sub-desc'><p><tt>true</tt> to destroy the node upon removal. Defaults to <tt>false</tt>.</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Node</span><div class='sub-desc'><p>The removed node</p>\n</div></li></ul></div></div></div><div id='method-removeListener' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-removeListener' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-removeListener' class='name expandable'>removeListener</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler. ...</div><div class='long'><p>Removes an event handler.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div><div id='method-replaceChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-replaceChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-replaceChild' class='name expandable'>replaceChild</a>( <span class='pre'>newChild, oldChild</span> ) : Node</div><div class='description'><div class='short'>Replaces one child node in this node with another. ...</div><div class='long'><p>Replaces one child node in this node with another.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>newChild</span> : Node<div class='sub-desc'><p>The replacement node</p>\n</div></li><li><span class='pre'>oldChild</span> : Node<div class='sub-desc'><p>The node to replace</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Node</span><div class='sub-desc'><p>The replaced node</p>\n</div></li></ul></div></div></div><div id='method-resumeEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-resumeEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-resumeEvents' class='name expandable'>resumeEvents</a>( <span class='pre'></span> )</div><div class='description'><div class='short'>Resume firing events. ...</div><div class='long'><p>Resume firing events. (see <a href=\"#!/api/Ext.util.Observable-method-suspendEvents\" rel=\"Ext.util.Observable-method-suspendEvents\" class=\"docClass\">suspendEvents</a>)\nIf events were suspended using the <tt><b>queueSuspended</b></tt> parameter, then all\nevents fired during event suspension will be sent to any listeners now.</p>\n</div></div></div><div id='method-setFirstChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-setFirstChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-setFirstChild' class='name expandable'>setFirstChild</a>( <span class='pre'>node</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-setId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-setId' class='name expandable'>setId</a>( <span class='pre'>id</span> )</div><div class='description'><div class='short'>Changes the id of this node. ...</div><div class='long'><p>Changes the id of this node.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>id</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The new id for the node.</p>\n</div></li></ul></div></div></div><div id='method-setLastChild' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-setLastChild' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-setLastChild' class='name expandable'>setLastChild</a>( <span class='pre'>node</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>node</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-setOwnerTree' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-setOwnerTree' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-setOwnerTree' class='name expandable'>setOwnerTree</a>( <span class='pre'>tree, destroy</span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'>private ...</div><div class='long'><p>private</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tree</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>destroy</span> : Object<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-sort' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-sort' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-sort' class='name expandable'>sort</a>( <span class='pre'>fn, [scope]</span> )</div><div class='description'><div class='short'>Sorts this nodes children using the supplied sort function. ...</div><div class='long'><p>Sorts this nodes children using the supplied sort function.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fn</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>A function which, when passed two Nodes, returns -1, 0 or 1 depending upon required sort order.</p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope (<code>this</code> reference) in which the function is executed. Defaults to the browser window.</p>\n</div></li></ul></div></div></div><div id='method-suspendEvents' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-suspendEvents' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-suspendEvents' class='name expandable'>suspendEvents</a>( <span class='pre'>queueSuspended</span> )</div><div class='description'><div class='short'>Suspend the firing of all events. ...</div><div class='long'><p>Suspend the firing of all events. (see <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a>)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>queueSuspended</span> : Boolean<div class='sub-desc'><p>Pass as true to queue up suspended events to be fired\nafter the <a href=\"#!/api/Ext.util.Observable-method-resumeEvents\" rel=\"Ext.util.Observable-method-resumeEvents\" class=\"docClass\">resumeEvents</a> call instead of discarding all suspended events;</p>\n</div></li></ul></div></div></div><div id='method-toString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-method-toString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-method-toString' class='name expandable'>toString</a>( <span class='pre'></span> )<strong class='private signature' >private</strong></div><div class='description'><div class='short'> ...</div><div class='long'>\n</div></div></div><div id='method-un' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.util.Observable' rel='Ext.util.Observable' class='defined-in docClass'>Ext.util.Observable</a><br/><a href='source/Observable.html#Ext-util-Observable-method-un' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.util.Observable-method-un' class='name expandable'>un</a>( <span class='pre'>eventName, handler, [scope]</span> )</div><div class='description'><div class='short'>Removes an event handler (shorthand for removeListener.) ...</div><div class='long'><p>Removes an event handler (shorthand for <a href=\"#!/api/Ext.util.Observable-method-removeListener\" rel=\"Ext.util.Observable-method-removeListener\" class=\"docClass\">removeListener</a>.)</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>eventName</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a><div class='sub-desc'><p>The type of event the handler was associated with.</p>\n</div></li><li><span class='pre'>handler</span> : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><div class='sub-desc'><p>The handler to remove. <b>This must be a reference to the function passed into the <a href=\"#!/api/Ext.util.Observable-method-addListener\" rel=\"Ext.util.Observable-method-addListener\" class=\"docClass\">addListener</a> call.</b></p>\n</div></li><li><span class='pre'>scope</span> : Object (optional)<div class='sub-desc'><p>The scope originally specified for the handler.</p>\n</div></li></ul></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-event'>Events</h3><div class='subsection'><div id='event-append' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-event-append' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-event-append' class='name expandable'>append</a>( <span class='pre'>tree, this, node, index</span> )</div><div class='description'><div class='short'>Fires when a new child node is appended ...</div><div class='long'><p>Fires when a new child node is appended</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tree</span> : Tree<div class='sub-desc'><p>The owner tree</p>\n</div></li><li><span class='pre'>this</span> : Node<div class='sub-desc'><p>This node</p>\n</div></li><li><span class='pre'>node</span> : Node<div class='sub-desc'><p>The newly appended node</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index of the newly appended node</p>\n</div></li></ul></div></div></div><div id='event-beforeappend' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-event-beforeappend' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-event-beforeappend' class='name expandable'>beforeappend</a>( <span class='pre'>tree, this, node</span> )</div><div class='description'><div class='short'>Fires before a new child is appended, return false to cancel the append. ...</div><div class='long'><p>Fires before a new child is appended, return false to cancel the append.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tree</span> : Tree<div class='sub-desc'><p>The owner tree</p>\n</div></li><li><span class='pre'>this</span> : Node<div class='sub-desc'><p>This node</p>\n</div></li><li><span class='pre'>node</span> : Node<div class='sub-desc'><p>The child node to be appended</p>\n</div></li></ul></div></div></div><div id='event-beforeinsert' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-event-beforeinsert' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-event-beforeinsert' class='name expandable'>beforeinsert</a>( <span class='pre'>tree, this, node, refNode</span> )</div><div class='description'><div class='short'>Fires before a new child is inserted, return false to cancel the insert. ...</div><div class='long'><p>Fires before a new child is inserted, return false to cancel the insert.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tree</span> : Tree<div class='sub-desc'><p>The owner tree</p>\n</div></li><li><span class='pre'>this</span> : Node<div class='sub-desc'><p>This node</p>\n</div></li><li><span class='pre'>node</span> : Node<div class='sub-desc'><p>The child node to be inserted</p>\n</div></li><li><span class='pre'>refNode</span> : Node<div class='sub-desc'><p>The child node the node is being inserted before</p>\n</div></li></ul></div></div></div><div id='event-beforemove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-event-beforemove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-event-beforemove' class='name expandable'>beforemove</a>( <span class='pre'>tree, this, oldParent, newParent, index</span> )</div><div class='description'><div class='short'>Fires before this node is moved to a new location in the tree. ...</div><div class='long'><p>Fires before this node is moved to a new location in the tree. Return false to cancel the move.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tree</span> : Tree<div class='sub-desc'><p>The owner tree</p>\n</div></li><li><span class='pre'>this</span> : Node<div class='sub-desc'><p>This node</p>\n</div></li><li><span class='pre'>oldParent</span> : Node<div class='sub-desc'><p>The parent of this node</p>\n</div></li><li><span class='pre'>newParent</span> : Node<div class='sub-desc'><p>The new parent this node is moving to</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index it is being moved to</p>\n</div></li></ul></div></div></div><div id='event-beforeremove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-event-beforeremove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-event-beforeremove' class='name expandable'>beforeremove</a>( <span class='pre'>tree, this, node</span> )</div><div class='description'><div class='short'>Fires before a child is removed, return false to cancel the remove. ...</div><div class='long'><p>Fires before a child is removed, return false to cancel the remove.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tree</span> : Tree<div class='sub-desc'><p>The owner tree</p>\n</div></li><li><span class='pre'>this</span> : Node<div class='sub-desc'><p>This node</p>\n</div></li><li><span class='pre'>node</span> : Node<div class='sub-desc'><p>The child node to be removed</p>\n</div></li></ul></div></div></div><div id='event-insert' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-event-insert' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-event-insert' class='name expandable'>insert</a>( <span class='pre'>tree, this, node, refNode</span> )</div><div class='description'><div class='short'>Fires when a new child node is inserted. ...</div><div class='long'><p>Fires when a new child node is inserted.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tree</span> : Tree<div class='sub-desc'><p>The owner tree</p>\n</div></li><li><span class='pre'>this</span> : Node<div class='sub-desc'><p>This node</p>\n</div></li><li><span class='pre'>node</span> : Node<div class='sub-desc'><p>The child node inserted</p>\n</div></li><li><span class='pre'>refNode</span> : Node<div class='sub-desc'><p>The child node the node was inserted before</p>\n</div></li></ul></div></div></div><div id='event-move' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-event-move' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-event-move' class='name expandable'>move</a>( <span class='pre'>tree, this, oldParent, newParent, index</span> )</div><div class='description'><div class='short'>Fires when this node is moved to a new location in the tree ...</div><div class='long'><p>Fires when this node is moved to a new location in the tree</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tree</span> : Tree<div class='sub-desc'><p>The owner tree</p>\n</div></li><li><span class='pre'>this</span> : Node<div class='sub-desc'><p>This node</p>\n</div></li><li><span class='pre'>oldParent</span> : Node<div class='sub-desc'><p>The old parent of this node</p>\n</div></li><li><span class='pre'>newParent</span> : Node<div class='sub-desc'><p>The new parent of this node</p>\n</div></li><li><span class='pre'>index</span> : <a href=\"#!/api/Number\" rel=\"Number\" class=\"docClass\">Number</a><div class='sub-desc'><p>The index it was moved to</p>\n</div></li></ul></div></div></div><div id='event-remove' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.data.Node'>Ext.data.Node</span><br/><a href='source/Tree.html#Ext-data-Node-event-remove' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.data.Node-event-remove' class='name expandable'>remove</a>( <span class='pre'>tree, this, node</span> )</div><div class='description'><div class='short'>Fires when a child node is removed ...</div><div class='long'><p>Fires when a child node is removed</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>tree</span> : Tree<div class='sub-desc'><p>The owner tree</p>\n</div></li><li><span class='pre'>this</span> : Node<div class='sub-desc'><p>This node</p>\n</div></li><li><span class='pre'>node</span> : Node<div class='sub-desc'><p>The removed node</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.util.Observable"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[],"event":[],"css_mixin":[]},"files":[{"href":"Tree.html#Ext-data-Node","filename":"Tree.js"}],"linenr":153,"members":{"property":[{"tagname":"property","owner":"Ext.data.Node","meta":{},"name":"attributes","id":"property-attributes"},{"tagname":"property","owner":"Ext.data.Node","meta":{},"name":"childNodes","id":"property-childNodes"},{"tagname":"property","owner":"Ext.data.Node","meta":{},"name":"firstChild","id":"property-firstChild"},{"tagname":"property","owner":"Ext.data.Node","meta":{},"name":"id","id":"property-id"},{"tagname":"property","owner":"Ext.data.Node","meta":{},"name":"lastChild","id":"property-lastChild"},{"tagname":"property","owner":"Ext.data.Node","meta":{},"name":"nextSibling","id":"property-nextSibling"},{"tagname":"property","owner":"Ext.data.Node","meta":{},"name":"parentNode","id":"property-parentNode"},{"tagname":"property","owner":"Ext.data.Node","meta":{},"name":"previousSibling","id":"property-previousSibling"}],"cfg":[{"tagname":"cfg","owner":"Ext.data.Node","meta":{},"name":"id","id":"cfg-id"},{"tagname":"cfg","owner":"Ext.data.Node","meta":{},"name":"leaf","id":"cfg-leaf"},{"tagname":"cfg","owner":"Ext.util.Observable","meta":{},"name":"listeners","id":"cfg-listeners"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addEvents","id":"method-addEvents"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"addListener","id":"method-addListener"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"appendChild","id":"method-appendChild"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"bubble","id":"method-bubble"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"cascade","id":"method-cascade"},{"tagname":"method","owner":"Ext.data.Node","meta":{"private":true},"name":"clear","id":"method-clear"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"contains","id":"method-contains"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"destroy","id":"method-destroy"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"eachChild","id":"method-eachChild"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"enableBubble","id":"method-enableBubble"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"findChild","id":"method-findChild"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"findChildBy","id":"method-findChildBy"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"fireEvent","id":"method-fireEvent"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"getDepth","id":"method-getDepth"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"getOwnerTree","id":"method-getOwnerTree"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"getPath","id":"method-getPath"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"hasChildNodes","id":"method-hasChildNodes"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"hasListener","id":"method-hasListener"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"indexOf","id":"method-indexOf"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"insertBefore","id":"method-insertBefore"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"isAncestor","id":"method-isAncestor"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"isExpandable","id":"method-isExpandable"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"isFirst","id":"method-isFirst"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"isLast","id":"method-isLast"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"isLeaf","id":"method-isLeaf"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"item","id":"method-item"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"on","id":"method-on"},{"tagname":"method","owner":"Ext.data.Node","meta":{"private":true},"name":"onIdChange","id":"method-onIdChange"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"purgeListeners","id":"method-purgeListeners"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"relayEvents","id":"method-relayEvents"},{"tagname":"method","owner":"Ext.data.Node","meta":{"chainable":true},"name":"remove","id":"method-remove"},{"tagname":"method","owner":"Ext.data.Node","meta":{"chainable":true},"name":"removeAll","id":"method-removeAll"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"removeChild","id":"method-removeChild"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"removeListener","id":"method-removeListener"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"replaceChild","id":"method-replaceChild"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"resumeEvents","id":"method-resumeEvents"},{"tagname":"method","owner":"Ext.data.Node","meta":{"private":true},"name":"setFirstChild","id":"method-setFirstChild"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"setId","id":"method-setId"},{"tagname":"method","owner":"Ext.data.Node","meta":{"private":true},"name":"setLastChild","id":"method-setLastChild"},{"tagname":"method","owner":"Ext.data.Node","meta":{"private":true},"name":"setOwnerTree","id":"method-setOwnerTree"},{"tagname":"method","owner":"Ext.data.Node","meta":{},"name":"sort","id":"method-sort"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"suspendEvents","id":"method-suspendEvents"},{"tagname":"method","owner":"Ext.data.Node","meta":{"private":true},"name":"toString","id":"method-toString"},{"tagname":"method","owner":"Ext.util.Observable","meta":{},"name":"un","id":"method-un"}],"event":[{"tagname":"event","owner":"Ext.data.Node","meta":{},"name":"append","id":"event-append"},{"tagname":"event","owner":"Ext.data.Node","meta":{},"name":"beforeappend","id":"event-beforeappend"},{"tagname":"event","owner":"Ext.data.Node","meta":{},"name":"beforeinsert","id":"event-beforeinsert"},{"tagname":"event","owner":"Ext.data.Node","meta":{},"name":"beforemove","id":"event-beforemove"},{"tagname":"event","owner":"Ext.data.Node","meta":{},"name":"beforeremove","id":"event-beforeremove"},{"tagname":"event","owner":"Ext.data.Node","meta":{},"name":"insert","id":"event-insert"},{"tagname":"event","owner":"Ext.data.Node","meta":{},"name":"move","id":"event-move"},{"tagname":"event","owner":"Ext.data.Node","meta":{},"name":"remove","id":"event-remove"}],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.data.Node","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.data.Node","mixins":[],"mixedInto":[]});