#!/usr/bin/perl -w

use lib 't';
use Testdata;

use Test::More tests => @ciphers*@padstyles + 1;

BEGIN { use_ok (Crypt::ECB) }

my $ecb = Crypt::ECB->new;

foreach my $cipher (@ciphers)
{
	eval { $ecb->cipher($cipher) };
	SKIP: {	skip "$cipher not installed", 1*@padstyles if $@;

		my $ks = $ecb->keysize || 56;
		$ecb->key( substr($key, 0, $ks) );

		my $bs = $ecb->blocksize;
		my $text = "x" x $bs . "0";

		foreach my $padstyle (@padstyles)
		{
			$ecb->padding($padstyle);

			my $enc = $ecb->encrypt($text);
			ok($ecb->decrypt($enc) eq $text, "$cipher, $padstyle padding: en- and decrypting '$text'");
		}
	}
}
