package Data::OFN::Common;

use strict;
use warnings;

our $VERSION = 0.01;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Data::OFN::Common - OFN common data objects.

=head1 DESCRIPTION

Common immutable data objects for OFN (Otevřené formální normy) in the Czech Republic.

This objects are actual with L<2020-07-01|https://ofn.gov.cz/z%C3%A1kladn%C3%AD-datov%C3%A9-typy/2020-07-01/>
version of OFN basic data types standard.

=head1 SEE ALSO

=over

=item L<Data::OFN::Common::Quantity>

OFN common data object for quantity.

=item L<Data::OFN::Common::TimeMoment>

OFN common data object for time moment.

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Data-OFN-Common>

=head1 AUTHOR

Michal Josef Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© 2023-2025 Michal Josef Špaček

BSD 2-Clause License

=head1 VERSION

0.01

=cut

=cut
