## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Is_ec v1.1.5;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Is_ec::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Is_ec> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package
since this pattern is generated from the source at
L<svn://tug.org/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/ptex/hyph-is.ec.tex>

The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
% pTeX-friendly hyphenation patterns
%
% language: icelandic (is)
% encoding: ec
%
% This file has been auto-generated from hyph-is.tex
% with a script [texmf]/scripts/generic/hyph-utf8/generate-ptex-patterns.rb
% See the original file for details about author, licence etc.
%
\bgroup
\lccode"E1="E1
\lccode"E6="E6
\lccode"E9="E9
\lccode"ED="ED
\lccode"F0="F0
\lccode"F3="F3
\lccode"F6="F6
\lccode"FA="FA
\lccode"FD="FD
\lccode"FE="FE
\patterns{
.a^^f03
.a^^f0a4
.a^^f0k2
.a^^f0l4a
.af3n
.af3re
.afr3^^ed
.af1s4
.agn5^^fa
.al3e
.al4l
.am4s
.an3k
.ann4e
.ar2
.ar3a4b5
.arth5
.asp3
.aum5a
.^^e1m4
.^^e1n4a
.ba4
.da4
.dam5a
.dav3
.dr4
.ds4
.du4
.dust5
.ed5ik
.eftir5
.eigin5g
.eink4
.ekt4
.er4m
.eyf2
.fa4
.fi4
.fj^^e1r3
.fl4
.fla4
.fr4
.fr^^e11
.ga2
.gar4
.gas5l
.gd4
.gem5
.gja2
.gl2
.gr4
.gu4
.her5sk
.il4
.ingj5
.is4m
.^^eds1l
.ja2
.jar4
.ka4
.kal5e
.kam5e
.kap^^ed3
.kart5
.kast3
.kn4
.kr4
.kur4
.la4
.lag5e
.leik5sv
.l^^edb5
.lu4
.ma2
.maj5
.mak5r
.mi4
.mj4
.mu4
.mynst4
.na2
.n^^ed5f
.n^^fd5f
.ol4^^edu.
.^^f3a4
.^^f3^^f05al
.^^f3f4
.^^f3g2
.^^f3k4
.^^f3m4i
.^^f3s2
.pa4
.pl4
.ra2
.ram4
.r^^ed4
.r^^f3^^f04
.r^^fam3
.saman5
.sk4
.ski4
.skj4
.skr4
.sl2
.sm4
.sm^^e13l
.sn4
.snar5a
.sp4
.spr4
.st4
.sta2
.ta4
.ti2
.til3
.t^^ed5f
.tr4
.tu2
.tv^^ed1
.ung3l
.unn5usta
.^^far1
.^^fat1
.^^fat5s
.vegg5s
.vist3
.yfir3
.^^e6vi3s
.^^f6fl3
.^^f6gr5
.^^f6r3s
.^^f6t3u
2a3a4
a4ab
a4ad
2a1^^e12
2a1b
ab4a
3ab^^eds
a5by
ab^^e6k4l
4ac
2a1d4
a5d^^f3
a4du
1a^^f0
4a^^f0a^^f0
a^^f03al
a^^f03ar
2a^^f0fa
4a^^f0f^^f6
a^^f03g
a^^f03i
2a^^f0l
a^^f04li
4a^^f02m
2a^^f0sh
3a^^f0u.
2a^^f0v
2a1e
a5ei
a4es
2af
af3ald
af3arn
a3f^^e1
af4fr
af3g
a1fj
a3fl^^f3
a1flu
af5ork
a1fr
af3r^^e9
afr4u
a5fr^^e6
4afsd
af1sk
4afsso
af2u
a1ful
a1fun
3afur^^f0
2ag
a3gau
ag5^^e1l
ag5is
a5gj
agn4ara
ag2ne
ag5ot
a1gr
ag4ra
ags4i^^f0
ag4sp
ag4stj
ag4ul
ag3^^e6^^f0
4a1h
4ai
a3i^^f0
a4in
a^^ed4h
2aj
a3j^^f6
2ak
akaup4s
a5k^^e1
a1ke
a5kinnin
a5kistu
a1kj
ak5rei
aks4l
4akss
ak3u
a3kv
a5ky
a5k^^fd
a3k^^f6
2al
a1lag
4aland
a5landi^^f0
a5landinu
alas4
al^^e14
a4lem
al3er
al1f
al1g
5alge
3alh
alis4
al4^^edn
al3kj
alk5s
al3k2u
al4l^^ed
all2s
allst4
al4l^^fd
4alma^^f0
al5mann
al5m2i
a3log
a5lok
al5op
a5l^^f3^^f0
al4s^^e6t
al5up
al5^^fa
al3v4
a3ly
a1l^^e6
a1l^^f6
2am
am3ang
a3mann
am3ari
am3ars
am3a4s
am3dr
a3m^^ed
am3k
am2m
amm4is
a1m^^f3
am3se
ams2i
am1t
1an
3an.
3ana.
an3ada
4anag
2anal
4anau
2an^^e1
4and.
and1e
4an4d^^ed
andr4
4and^^f6
4ane
an5ei
2ang
an4ga
ang1d
an4gj
ang5spi
an2g3^^f6
4anib
4ani^^f0
an5^^edn
2ank
ank5l
ank3v
3anm
ann5d
4annf
4annh
ann1k
4annl
4anns
annsk4
4an4o
anst4
an3sti
an3t^^ed
3anu
4an^^fa
4an^^fd
4an^^e6
4an^^f6
2a3o
2a3^^f3
2ap
ap3al
a3per
a3pil
a3po
a5pre
ap3te
a5p4un
a5p^^f6r
1ar
3ar.
ar3afu
ara5kr
ar3ang
4arani
ar4arp
ar2as
ar5ast.
ar3au
2ar^^e14
4ar^^e1^^f0
5ar3^^e1k
3ar3^^e1r
3ar1^^e1s
ar1^^e1t
3ard2
4ard^^ed
4ar^^f0.
ar^^f0ar5^^e1
4ar^^f0i
4ar^^f0s
3ar^^f0u.
2are
3ar1ef
4aref.
5areig
5arein
a3rek
ar3el
ar3en
ar5er
a3ret
4a1r^^e9
2arf
3arfe
3arf^^e9
arfs3k
ar1fu
ar3gj
ar4gr^^e6
args4
arg3sl
4ar5i^^f0
4arif
ar3in
ar4ind
ar5ist.
4a5rit
4a1r^^ed
ar3j4
4ark.
ark4is
ar5kj
ar3kr4
4arms
ar3m^^fa
4arna.
4aro^^f0
4arol
4arot
2ar^^f3
2arp
4arra
arr2i
arr4u
ar4s^^e1
3arse
ar1sk
ar4spi
arst4
5arst^^ed
ar3su
ar5til
artr2
ar5tra^^f0
ar3u
ar4u^^f0
4ar4ug
5arum
2ar1^^fa
a5r^^fas
ar3v4
ar3yf
4ar^^fd
2ar^^e6
a3r^^e6^^f0
ar5^^e6v
4ar^^f6
as2
4a1sa
as3an
2a3s^^e1
4ase
4as^^e9
2asi
a5sinna
2asj
4a1sk
2asl
a3slag
2a1sm
4asn
4aso
4as^^f3
2asp
asp^^edt4
4ass
ass4v
1ast
4asta^^f0
ast4and
4astau
4aste
4ast^^e9
4astig
4astin
ast4ing
4astir^^f0
4a1st^^ed
4astj
ast3l
4asto
2ast^^f3
4astr^^e1
ast5r^^e1^^f0
4astr^^ed
4a3str^^e6
4astr^^f6
4astul
4a3st4un
4ast^^fa
4a3sty
4ast^^e6
4ast^^f6
2a1su
2a1sv
4as4y
2as^^fd
4as^^e6
2as^^f6
2at
at3a^^f0
a3tak
a3tal
at4anv
ata4r
a1te
at3ey
3ath
a1til
a3tj
3atk
atns3
a4t^^f3
atr4a
at1re
3at1ri
at2sp
a5t2un
a1t^^fa
at4ve
3atvi
a1t^^f6
2a4u2
4au^^f0.
au^^f05li
5au^^f0n
aug4as
au4m
aum5ba
aum5un
aun5dr
aup5e
aup3l
a5upp
au4s
ausa5m
au4t
2a1^^fa
2a1v
av4ar.
a3vir
2ay
a5yf
4az
2a1^^fe
a2^^fe^^f3
2a3^^e6
4a5^^f6
^^e11a
^^e1ak4
^^e1a5lo
^^e11b
^^e14bu
^^e11d4
4^^e1^^f0
^^e1^^f02s
^^e1^^f03sn
^^e1^^f03sta
^^e1^^f02u
^^e1^^f03us
^^e11e
^^e1f2
^^e15f^^e1
^^e15f^^ed
^^e13fl
^^e1fl^^e6^^f04
^^e1f5un
^^e1g2i
^^e1gl4
^^e1gr2
^^e1g1s
^^e1g3v
^^e11h
^^e11i
^^e1k2a
^^e1kam4
^^e1kap4
^^e1k^^f34
^^e1la3m
^^e1l3arf
^^e1l2as
^^e15lau
^^e13let
^^e1lf3d4
^^e1lf5sk
^^e1l4m
^^e1lm5an
^^e1lm5u
^^e1lp3
^^e1l4se
^^e1l5sva
^^e1l5ug
^^e15l^^fa
^^e1l3^^e6^^f0
2^^e1m
^^e1m^^e1l5a
^^e1msl4
^^e12n
^^e1n4aro
^^e1n2as
^^e1n4o
^^e13n^^fd
5^^e1n^^e6
^^e13o
4^^e1p
^^e1ra5g
^^e1r3an
^^e1rar4
^^e15r^^e9
^^e1r3f4
^^e1r5g
^^e1r5k4
^^e1r1m
^^e1rns4
^^e1rn5sl
^^e1r2st
^^e1r5t
^^e1r1u
^^e1r3v
^^e15r^^e6
^^e1s5en
^^e11sk
^^e12ska
^^e14ske
^^e13s4l
^^e1s2m
^^e1st2
^^e1st5i
^^e1st5r^^e1^^f0
^^e1st5r^^edk
^^e1st5v
4^^e1su4
^^e1s5va
^^e1t3a^^f0
^^e11te
^^e1tr4as
^^e1ttar3
5^^e1ttin.
^^e1tt3un
^^e11t^^e6
^^e11u
^^e1uk4
^^e13ve
^^e13v^^ed
^^e11v^^e6
^^e11^^fe
^^e15^^e6^^f0
b2a
4ba.
ba^^f0k4
ba4h
bak5sl
ba2n
4bana
4ban^^ed
bank5an
4bans
b5ant
bar2b
bar^^f04as
bar2n
b^^e14s
2b4b
bb3a^^f0
bb3an
bb5arn
bb3i
bb3u^^f0
1be
bess4
b2i2
bi^^f05i
bi^^f05lis
bi^^f05r4
bif1
bilj5
bill5
4binn
bisk3
b4it
bit2a
4b^^eda
2b3^^eds
2b3^^edu
3bj
bjar2
b4l2
bl4^^edunn
4bn
5bo
3b^^f34
b^^f3k3s
b4r2
br5a^^f0
bra4s
3bro
br4u
3br^^fa
4bum4
bur2
3bur^^f0
burst5a^^f0
bu4s
1b^^fa
b^^faf4
b^^fa3sta
1by
1b^^fd
b^^e6k2i
b^^e6n4a
1b^^e6r
b5^^e6ttism
1b^^f6
4b^^f6ki
c4a
ci4
ck4
4da.
daf4
dak2
3dal.
5dals
da1m4
d5ang
d4an^^ed
d4arad
d4ar4a^^f0
dar4^^e1r
d3arf
d5arp
dask4
da3sl
4dav
d1b
2dd
4dea
d5ef
3deg
1deil
d1en
d5e^^f3
5dep
d1f4
d1g2
d4gi
d1h
d1i
di5fu
d3ill
dim4
di3ma
di3nav
d2ine
dir3s
d^^ed3d
d5^^ed^^f0
d5^^ednu
3d^^eds
d^^edv3
3dj4
djarf5a
d1k2
d1l2
d2la
dl3a^^f0
d3lag
d3lau
d4li^^f0
dl3u
d1m
d5olf
d5^^f3^^f0
d3^^f3f
d^^f35l^^ed
1d^^f32m
d^^f3m5an
d^^f35ne
3d^^f3r
d^^f32s
d^^f3s5e
4dq
d5ra^^f0f
dr4a^^f0s5
d5ra^^f0st
drafn4
dr4ara
3dreg
d5reip
d5rey
d5ri^^f0a
d3r^^edk
d5ro^^f0
dru4
d4r^^e6t
2ds
d5sal
d4sj^^f6
dsk2
ds4ko
ds5kun
ds1l
d5sn^^f6
ds1s4
d1st4
d4sti
ds4u^^f0
d4s^^f6f
d1t2
d1u
duf4
5duft
duk4
d4umb
du5r^^e6
d4usta
d3^^fan
d^^fan4a
d^^fat4
d1v4
4dw
1dy
1d^^fd
d3^^fe
1d^^e6
4d^^e6f
4d^^e6r
3d^^f6
^^f01a
^^f0af4
^^f0a3g
^^f0ak4
^^f04albo
^^f03ald
^^f0al4is
^^f04a1m4
^^f03a4n
^^f0anmeg4
^^f0ar1a
^^f03ar3f
^^f0ar3l
^^f0ar4lis
^^f0ar3t4
^^f03ar^^fa
^^f0at4a
^^f03au
^^f03^^e12
^^f01b
^^f01d2
^^f01e
^^f03f4
^^f01g
^^f02ga
^^f02gi
^^f0g4l
^^f04gn
^^f0gu4
^^f03g4ul
^^f01h
^^f01i
^^f0i3g
^^f0ik4
^^f03in
^^f0is5l
^^f0ist4
^^f04ista
^^f0is4ve
^^f0j3as
^^f03j^^f3
^^f04ju
^^f03ke
^^f01kr
^^f0k2un
^^f03kunn
^^f01kv
^^f01l^^e1
^^f0l2in
^^f0l4ist
^^f03l^^ed
^^f0l4ur
^^f01l^^e6
^^f01m2
^^f0num4
^^f03o
^^f03^^f3
^^f01p2
^^f0r5^^e1t
^^f01re
^^f01r^^e9
^^f03rik
^^f03r^^edk
^^f05r^^f3
^^f0r1u
^^f03r^^fa
^^f01r^^e6
^^f0r^^e6^^f0is5
^^f0s5afl
^^f0s5^^e1
^^f04seg
^^f0s4inn
^^f01sk
^^f0skr4
^^f04sk^^fa
^^f0s5kv
^^f04sk^^f6
^^f0s4lu
^^f02so
^^f0s3or
^^f0ss4
^^f01st2
^^f02st^^ed
^^f03st^^f6
^^f0s4u
^^f04svi
^^f02s^^e6
^^f01t4
^^f01u
^^f03u^^f0
^^f03ug
^^f03ull
^^f05uls
^^f05unn
^^f03unu
^^f03ur
^^f0ur5^^e1
^^f0ur3f
^^f0ur5g4
^^f0ur5st
^^f01v
^^f0v5a^^f0
^^f0v3ann
^^f0v3arn
^^f01y
^^f05^^fd
^^f01^^fe
eat4
ebr5e
ed4e
e1dik
ed3it
e^^f03a2
e^^f0al1
e^^f03il
e^^f04is
e2f
e3fal
ef3i
efj5an
ef4n
4eft.
2efts5
eg4ge
eg3i
egr5u
eg3u4l
egur4s
e4i
ei^^f05ar
ei^^f04st
eif4as
ei4ka
eik3li
eik3u
eil3ag
eil5^^f6
ei2m
eim5u
eing4
1eink
4eino
eist5a^^f0
e4k
ek2is
ekj5a
ekn3
ek3u
ek5^^fa
e2l
el5^^e1s
el4d
el3eg
elf3in
el4gr
el1i
4el^^ed
el3^^edn
el4ke
el2l
ell5an
ell3e
elleg4
el3^^f3
el3r
el1s^^ed
5elsk
el4te
elu5s
e2m
em4ba
1embe
em5ens
em3i4
emj3
em4l
eml2i
empl5
em5u
e2n
4enc
en4g
eng3a
enik4
2enn
enn4t
en4t
ep4h
ep3i
epl5i
e4pr
ep4t
e4r
er3al
er5au
er5^^e1
4er^^f0
5ere
er5et
erf5ar
er2fr
erf3u
erg5l
er4gr
er3i
er2k
er4la
erl3i
er4l^^ed
er4mi
erm5in
er5^^f3l
er5skj
er1un
er2v
er3^^f6
er^^f6f4
e2s
es3a
es4ban
es4bu
4esj
e5ske
4eso
esp3a
es2s
est3a^^f0
est5^^f6
e3s^^e6
etik4
et5ils
etna4
et5o
etr5an
etr3u
etul4
et2us
ext4u
5eyrar
^^e93b
^^e91d
^^e9^^f02s
^^e93fe
^^e91g4
^^e95ky
^^e91l
^^e9la4g
^^e9l4ara
^^e92li
^^e94lj
^^e9l3r
^^e9r1
^^e9r4^^e1
^^e9r4r
^^e9rs4
^^e9r4un
^^e9r3v
^^e93sm
^^e9tt4ug
^^e9t4un
^^e9tur4
f3a^^f0
fa2g
fa5k
1fall
fal4u
fa4n^^e1
fa5p4
f2ar
f3ar^^f0
f4are
f4arg
farka5l
f3arl
fast3e
f^^e13f
f5^^e1ns
f^^e13r^^e1
f^^e13ta
f^^e13v
f1b4
fd2an
f1dr
f5d^^fa
f^^f0a4l
1fe
f3ef
f3ein
3fel
f3end
ferl5i
fer3t
f1ey
1f^^e9
f4fa
f2fo
f1fr
ff4st
ff^^e6r4a
f1g2
f2ga
f2gi
fg4n
f1h
f3i^^f0
fik4
f5il.
f5ili
f3ill
f5ils
f5ilv
fim3a
f4ine
f3inu
3fir^^f0i
f3ir^^f0u
firg2
f3irn
1firs
3f4isk
fi5so
f3ist.
f3istu
fis5v
f^^ed4
f5^^edkv
f3^^eds
fj4a
fj5a^^f0u
fj5ann
fj4e
f1k2
fl3and
fl4at
3flata
f5l^^e1t
f4len
fl5g
1flo
5flut
flv4
4fl^^fd
1fl^^f6
f1m
4fn
fn1g
f5n4^^ed
fn3k
fn5ok
1fo
4fop
forf4
fork4
1f^^f3
fr2
4fra.
fr3a^^f0
fra4m
fram3l
fr5and
4frar
2fri.
fr5in
fr^^ed5m4
f3r^^f3f
fru4
fr3u^^f0
1fr^^e6
2f3r^^e6k
4fr^^e6n
fs3^^e1
f4sel
f4skaf
fsl4
fs3li
fs5na
f2so
fs5or
fsr4
fss4
f4sti
f5s4t^^e6
fs1v
f4s^^e6
ft3a^^f0
fta4sk
ft5^^e1
f3te
ft2s
fts5l
ft3u
ft4ul
f1u
4fu.
f3u^^f0
3fugl
fund4as
2f3ur
5fur^^f0ul
fur5e
furs4
fur3t
4f2us
f5ust.
f3ustu
f1v4
1fy
f3yrt
f1^^fe
1f^^e6
1f^^f6
f^^f6r4l
g1a
4ga.
4g3a^^f0
gaf4ar
gagl4
3gagn
gak4
ga4lag
gal4is
5gals
5galt
gam3al
gam4i
g5and
1gang
gap4a
g4ard.
g2ar^^f0
3gar^^f0.
3gar^^f0a
3gar^^f0i
3gar^^f04s
5gar^^f0ur
g3ar3f
gar4kl
gar3l
gar3t
4gas
g4as.
g4as^^ed
g3ast.
ga5sta^^f0
1gata
gat4r
g^^e12
3g^^e1f
g^^e15le
g1b
gd4ans
g3de
g4du
gd4v
g^^f04aro
1ge
3gei
2g1el
gen4
g5end
3geng
g3ent
5ger^^f0
ger5^^ed
germ4
gerv5a
get3r
g1f2
ggis5
ggjaf3
ggj5ar
gg5r^^e1
gg3r^^e6
ggs4v
gg3ug
gg2v
g4g^^f6
g1h
g1i
4gi.
4gik
gi5kv
3gild
g5ill
5gilt
gim4a
4g3i4n
gis4a
g4isp
g5ist^^e6
g^^edr5a
g^^eds4
gjaf5ar
gjaf5o
gjak4
gjal4
gj4asta
1gj^^f6
g1k4
gkal4
g1l^^e1
g4le^^f0
g3leg
gl5^^e9
gl3f2
g3lit
g5l^^edn
gl3^^f3t
glsk4
3glugg
glu3s
gl4y
g3l^^e6r
g1m4
gnap4
gnart4
g4n^^e1
gn3g
g3n^^f3
gn4se
gn5ug
g4n^^fd.
3gol
g3or
3g^^f3^^f0
g^^f3r5
g^^f34ur
g1p
g3rak4
gr4an
gra2s
gras5sv
g2r^^e1
1grei
g3reis
g5rey^^f0
gr2i
2gri.
gri^^f04
g3r^^edk
3gr^^f3
3grund
3grunn
g3r^^e6^^f0i
g2r^^e6n
4gs
gs1^^e1
g4sei
gsk4
gs4len
gsl2u
gs4l^^f6
gs3m
gs5or
gs3s4
gs4si
gs1v
gt3a^^f0
g3te
gt4s
2g1u
g4u^^f0i
gu^^f0l4
5g2u^^f0s
gu^^f04s^^f3
g3u^^f0u
5gufu
gu4lagi
g5ulin
g3ull
g3uls
gu5mi^^f0
g3un
gurf4
gur3g
g4usta
g3^^fa
g^^fast5a
g1v
g2va
g3val
5gy^^f0
g1^^fe
1g^^e6
g^^e6^^f04as
g^^e6l4
g^^e6r3
1g^^f64
h2a4
4ha.
ha^^f04
haf4sp
hand5r
hat3r
h^^e13g
h^^e1l4
h^^e13re
h^^e14ski
h^^e15sta
h^^e1s4u
h^^e1t4
h^^e15ti
h^^e1tr4
h^^e11v
he4
hei2
hellis5
hen2r
herk4
her3l4
hersk4
4hersla
hey5st
4hg
h4i
hig4
him5b
hin4
hit4as
hit4n
2h^^ed2
h5^^eda
h^^ed5b
hj4
h2l2
4hl.
4hls
hlu4
h4n2
hnja4
hnj^^e13l
holl3u
horm5
h^^f32
h^^f3m5e
h^^f3t3
hr4
4hs
hu4
hug1r
hug3u
hul5i
hundr4
h^^fa2
h^^fam3
4h^^far
h^^fas5k
hv4
hvar4
hvik3
5hy
h^^e6f5a
h^^e6tt4us
h^^f6st3
2ia
i5as
4i5^^e1
4i1b
ibb3
ibl3^^ed
4ic
2id4
i3da
i1de
i3dr
1i^^f0.
4i^^f0f
2i^^f03g
i^^f05jar^^f0
4i^^f0r
4i^^f0s
i^^f05sal
2i^^f0u
4ie
i3ef
4if
if5arn
ifat4
i2fen
if4g
if3is
if4t
i4fy
4i2g
iga3m
ig^^f05u
ig1en
ig5r^^ed
2i1h
2ii
i5i^^f0
4ij
4ik
ik5^^e1
ik3i
ik4is
ikt5o
i4kv^^f6
2il
ila2g
il4ara
i1l^^e1
4ile
ilf4a
il1fi
il1g4
i5li^^f0u
il5in
il3ip
il5^^eds
il^^ed4um
il4kv
il3lag
ill5an
il3l^^e1
i1lo
il4sa
il1sk
il3sn
ilst4
il^^e6k4
i5l^^f6n
4im
im4b
imb3u
im3i
im4i^^f0
im4la
im4m
i5m^^f3
im4sv
1i2n
4inaf
in3an
4inar
inat5r
2i3nau
2ina2v
inav3^^ed
4in^^e1
4ind.
in4ga
ingj6arni
4ingr
ingv4
2inns
2innu
in1o
4in^^f3
in1s4k
in2sp
in3sta
in5ul
4in^^fd
2i3o
4i^^f3
2ip
i5pil
3ir.
4ira
2i1r^^e1
2ir^^f0i
4ir^^f0n
4ire
4ir^^e9
irf2i
4irfs
4irig
2irit
4i1r^^ed
2irk
irk3u
ir3l
ir1m4
4irnd
4irni.
4irnin
4irnis
4ir^^f3
irs4^^e1
irst4
ir3tal
irt5i
4irtl
irt4^^f6
ir3ug
4ir^^fa
4ir^^f6
i2s
1is.
2isa
4isag
i5saga
i3sam
is2as
3isd
2ise
4ishv
3isins
4is^^ed4
4isj
i3sj^^f3
2isk
is4ka
isk5el
iski3m
isk5inn.
3isko
isk2u
isk1v
5isk^^f6
2isl^^e9
is3l^^e6
5isma
is5me
4isni
isp3a^^f0
isp3u
iss2i
is5s^^fa
ist3al
2iste
4ist^^e9
4istig
i5stik
ist4is
ist5^^edn
4isto
4ist^^f3
4isty
4ist^^e6
2ist^^f6
is5t^^f6k
is1v
4isvi
is4vi^^f0
5isvin
i3sv^^e6
2is^^f6
2it
it3a^^f0
it5ann
i5tei
4ith
it4ha
it5ill
itis4m
it2ka
itn5es
it3r^^ed
it4st^^f6
it3un
it4urn
it4ve
4iu
4i^^fa
4i1v
i2v5^^eds
4ixs
2i3^^fe
4i^^e6
4i^^f6
^^ed1a
4^^ed5ak
^^edal3
^^ed5ald
^^ed3ali
^^ed2as
^^ed5at
^^ed5au
^^ed5^^e1
^^edb4a
^^ed5bar
^^ed4be
5^^edb^^fa
^^ed5dag
^^ed^^f02s3
^^ed^^f0sk4
^^ed3el
^^ed3en
^^edet3n
^^ed5ett
^^ed2f
^^edf3e^^f0
^^ed4f3i
^^edf5r^^ed
^^edfs3k
^^edf4sp
^^ed2g
^^edg3e
^^ed3gil
^^ed1h
^^ed1i
^^edk3a4
4^^edk4anar
4^^edk4ani
^^edk5is
^^edkk2i
5^^edkm
^^edk2n
^^edkn5e
^^edk4s
^^edk3us
2^^edl
^^edlak4
^^edl2as
^^edl5^^e1r
^^edl5f4
^^ed3l^^ed
5^^edlm^^e1
^^edl3sk
4^^edm
^^edm3a^^f0
^^edma3l4
^^edm3an
^^edm4g
^^edm5o
^^edm5t
^^edm3un
^^ed2n
^^ed5n^^e1
^^edn5e
^^edn3ge
^^edn5t
^^ednu3g4
^^edn3^^fa
^^ed3^^f3p
^^ed^^f3p5^^edu
4^^edp
^^edr5ak
^^edra4s
^^ed4r5i
^^edr4sv
^^edr3t
^^ed1r^^e6
^^edr5^^f6
^^ed2se
^^ed4s5j
^^edsl2
3^^edslen
^^edsl5i
^^eds2m
^^ed2st
^^eds5ter
^^edt5a^^f0
^^edt5als
^^edt3i
^^edtj5
^^edt3re
^^edtr5^^f3
4^^edub
^^ed5u^^f0
4^^edul
^^edu1ma
^^ed3un
^^edu5p
^^ed3ur
^^ed4ura
4^^edusa
^^edu3t
4^^eduv
^^edvo4
^^ed5^^fe
j2a
j3a^^f0
j5a^^f0i
3jaf4n
ja5kl
jal2
jal5i^^f0
ja5l^^f3
j4am
j3an
j4aram
j3ari
jark4i
jarn4i^^f0
j4ar^^e6
jas4
jask4u
j3ast
j^^e1l5as
j^^e1l4f
j^^e1lf3a
3j^^e1rn
j^^e1r4u
j^^e1v3
j^^e1var5
j1e
jend4a
j4ep
j4er
j4et
j1i
j^^f35b
j^^f35fr
j^^f32s
j^^f35ug
j^^f33ve
j1u
juf4
jug2
jug5as
ju4g^^f3
j4u1l2
jur4e
5j2urt
jurt4i
j2us4
j3ust.
3j^^f6fn
3j^^f6k
j^^f6l3k
j^^f6l1m
ka^^f04s
kaf4an
ka4fr
kag4as
ka4j
kaj5a
kak4l
kal2
3kald
4kalf
k4all
3kam4b
kam2s5
k3ana
k4anaf
k3ann.
k4an^^f3
k4ant
5kanta
4kapa
kark4
1k2ar2l
k4arm
k3arn
kar2r
k4art
kar4v
kask4
3kass
5kastal
k5astu.
1kau
5kaup
k^^e1k5
k^^e1m3
k1b
k1d4
2k1end
3kenn
3kerf
5kerl
ker4m
k1f4
kfalls5
k3g
kgl4
k1h
k3i^^f0
ki^^f05l
kig4
k5ill
k5ilsi
kim2
k5ing
k4ip
k1ir
k3ir^^f0
5kirk
k5irn
k4irt
k1is
k5ise
kisk4
k3ist.
k4it
ki3te
3k^^edl
k^^eds3
k^^edt3u
kja4l
kjar4a
kjar5f
kju3g
1kj^^f6
3kj^^f6r
kka5l
kk5e
kkj1^^f3
k2kl
kk1l^^e1
kk4li
kk3r^^ed
kk4se
kkul4
kkv5i^^f0
kl2
kl3a^^f0
kl3ann
kl^^e14
5klef
kleif5a
k4lem
k1lin
3klj
3kluk
3kl^^fa
1kl^^e6
k1m2
k4mi^^f0.
kn3ar
k2ney
kni5svi
3kn^^fa
1ko
2kob
koff5
kol5d
kol4l
kol5sv
3kon
4kons
3kos
kot4as
k^^f33d
k^^f33m4
k^^f3r5a
k1^^f3tt
kra5l
kr2as
k2r^^e1
k5r^^e9
kr2i
krif3a
1kr^^f6
3kr^^f6f
4ks
ks4l^^ed
ks4l^^f6
ks4m^^e1
ks4n
ksp4
k4ste
k4st^^f3
k4str
ksyf4
kt3a^^f0
kt5er
k4t^^ed
k3tora
k5ty
2k1u
k3u^^f0
k4u^^f0i
kuf4
kuk4
kulegr4
kum4
kumb5
k5un.
k5una.
k3unar
k5uni
5kunn^^e1tta
k3unu
k3ups
k2ur^^f0
kur5k
k2us
ku5sl
k3ust.
k5ustum
ku3sty
k^^fa2
3k^^falu
k3^^fan
k^^fa3re
k^^fat4us
3kven
4kv^^e9
4kvu
kv4un.
1k4v^^e6
3kv^^f6
4kv^^f6r
k5^^fe
3k^^f6k
5k^^f6ld
5k^^f6nn
5k^^f6s
2la.
4lac
la4dan
2la^^f0
la^^f04al
4laf
laf4as
laf4r
l3afs
3lag^^f0
4lage
2lak
la5k^^f3
la1l2
l3ald
lam4b
2lana
l2and
3land.
3lands
1lang
lank5as
4lann
l5anna.
l4an^^f3
lan4t
la3pl4
2lar
l4aram
l4are
larg4
l4aris
l3arn
la3r^^f3
lart4
l4ary
2las
las3i
las3le
la5sli
last5a^^f0
lat3^^edn
lat4u
1lau
2laum
laut5as
l^^e12g
l^^e1m5a
l^^e1n5e
4l^^e1r
l^^e14t
5l^^e1tum
l^^e13v
2l1b
2ld
ld3ar
ld3d
ldem4
ld3ey
ldig4
ldr4as
ld5rau
l4dri
ld5ro
ldr3^^f3
1le
4le.
2lef
l1efn
4legn
leif5as
leik3v
4lein
4lek
4lel
4lenn
4lep
2ler
le5r^^ed
les5e
2let
l3ex
2ley.
4leyj
2leym
lf4as
lf5^^e1t
lf4dr
lf3f
lf2i
lf5inn.
l3fj
lf2l
lfla4
l4f^^f3
lf4sp
lftr4
lft4un
4lg
lg2a
lgar4s
lg5ast
l1g^^e1
l4ges
lgil4
lg4isi
lg3^^ed
lgl4
lgni5s
l1gr
lg4^^fa
l1h
4li.
lik4a
li5kv
lil2
li5la
li3li
l2ind
4lings^^e1
l3inn
l5inn.
2l3inu
4l3ir
l1is
l5is.
l4is^^e1
l3isi
lisk4
l5isr
l4isti
l5istu.
lit4ar
3litl
l3^^eda.
l^^ed4b
1l^^edf
l^^edf5a
l^^edk3k
l^^edm5ug
4l^^edp
1l^^edt
l1^^edu
l4^^eduf
l4^^eduh
l4^^edutr
lj3ar
lj5ar^^f0
1lj^^f3s
lj^^f3s5k
lj^^f3s3l
lj3ug
ljur4
lj4uru
2lk
lkap4
lk4as
l1ke
l3kr
l3k^^far
l1kv
l3ky
2ll
ll3et
l4ley
ll3f
ll1g2
ll3i^^f0a
lli3g
lliss4
l1lit
ll^^edt4
ll3k4
ll3m
ll1^^f3t
lls5t^^e6
ll5te
ll5ug
ll3v
2lm
lm5ari
lm3ars
lmb4
l3me
l1m^^f3
lnar4
ln4i^^f0
l5no
lo4
5lo^^f0
5loki
4lon
4l1or
5los
l^^f3^^f03r
l^^f35gr
l^^f34ma
lp5t
2l1r
l2ri
l3rit
2ls
ls^^ed4
l2sj4
l5skin
ls4kon
ls4nesi
l3sta^^f0
lst4in
ls1ve
4lt
lt3a^^f0
l5til
lt4s
lt4^^fa
l1t^^e6
2lu
4lu.
l3u^^f0
lugl4
luk4i
l4u1l4
l1um
lu1ma
l1un
3lund
l3unu
lu5pe
l1ur
2l1v
l2va
lv3a^^f0
l3val
l4v^^edu
ly4
3lyf
1lyn
l1yr
1l^^fd
2l^^fdf
l^^fdt4a
4l^^fdti
2l1^^fe
1l^^e6g
l^^e6kj3
l^^e6kjar5
5l^^e6kk
1l^^e6ti
1l^^f6g
l5^^f6l
4l^^f6t
m2a
2ma.
m4ab
m4ad
m3a^^f0.
m3a^^f0a
m3a^^f0i
m3a^^f0r
m5a^^f0s
1ma^^f0u
maf4
m4ag
3mag4n
m4ak
mal4as
mal3dr
m3alf
m3all
m4alp
mal4t
ma1m4
4man.
4mana.
m4an^^e1
m3anb
2m3and2
m3ank
m3anl
mann4as
3manni
3manns
mann5t
2m3ans
man5sa
m3ant
4manu
ma2r
m3ara
m3arb
m3ar^^f0
1m4ark
marks5
m3arn
mar3o
mar4s
mars5m
m4ar^^fa
m1as
mask4
ma4sp
m3ast.
1m^^e1
4m^^e1.
3m^^e12l
m^^e1l3f4
2m^^e1m
m^^e15mu
m^^e15p
4m^^e1r
4mb
mb5a^^f0i
m1ban
mb3i
mb4ir
mb3un
md2as
md5asta
md4v
1me
4me.
me^^f03
m5ef
megin3
5m2eis
meltr4
m1end
3menn
m5erh
m3er3^^ed
mest5a
m1f4
m4f^^ed
mf^^f6r4u
m1g2
mgl4
m1h
mi^^f03i
mi^^f0r4
mi3ge
3mik
milj3
mil4l
millj3
m3ing
5minj
m3inn.
min4s
m3inu
m3ir
m1is
mis3k
mis3lu
mism4
2m^^ed
mj^^f33sl
m1k
m2ka
mk4arg
mk4as
mk2i
mk4l
m1l
m2la
m3lag
m3lau
m2l^^e1
ml3^^e1r
m2li
m5luk
4mm
m2m3a
mm5b
m4m^^f3
mm4sv
mm3u
m4nesku
2mog
4mok
3mol
mong5
m^^f3d3
m^^f3^^f04s
m^^f35g4
m5^^f3n^^ed
m^^f33rau
m^^f34s
3m^^f3t
mp3^^e1
m5pe
mp3i
m3rau
m5r^^e1
m3re
m3r^^fd
m1r^^e6
4ms
ms5^^e1l
m2se
ms5ei
m5skau
ms5kj
ms5l^^e1
msn4
mssetr4
m1sv
m4sv^^ed
mt3a^^f0
m4ti
mt2is
m3tug
mt5un
mt4us
mt2v
m1t^^f6
m1u
4mu.
mug4u
4mul
4mum
m2un
1mund
m3ung
4mur
m4uru
mu5sta
m3^^fa^^f0
m^^fag4u
m1^^fan
m^^fas4a
m1v4
1my
3m^^fd
m^^fd5m
m1^^fe
1m^^e6
1m^^f6
m^^f6r4
n1a
4na.
na2da
na4d^^ed
na^^f0ar3
naf4
nafl4
nafl5an
3nafn
nak4a
na4kr
nal2
na3la
n3ald
na3li
na1ma
n4anaf
n5ang
n5ann
n4arak
n3ar3f
n4arfi
n4arf^^f6
narg4
n4aris
nar5m
nar5rin
n4aru
n4ar^^fa
nat4
n5aug
n3auk
naum5a
1n^^e1
n^^e11g
n^^e11k
3n^^e14m
n^^e1n5ast
n1b
nb^^e6j4
nd3er
nd4isv
n4dj
nd3^^f3t
nd3rek
ndr1u
nd1r^^e6
nd4sen
nd3ug
nd5ul
ndur5g
nd3^^fa
1ne
ne^^f02s
3n2ef
4nefl
n4em
nem5a
2n1en
4n4er
nestr4
netl4
n5eyi
n3eyj
n^^e95sk
n1f2
nfr4
nga1m
ng5are
ng2as
n2ge
ng5ek
n3ger
n3get
ng1ey
ngi5k
ngil4i
ngi5li^^f0
ng5lag
ngl2i
ngl5i^^f0
ng5^^f3lfs
ng4ra
ngr5an
n3gr^^ed
ngr3u
ng3r^^e6
ng4sj
ng4sp
ng4ste
ngurs3
ngu3t
n1h
4n1i
n4i^^f0i
ni5fr
ni3gr
ni3lu
ni5m
n4iru
n3isa
n4is^^e1
nisk4
ni3sk^^f3
nis2m
nis5s
ni3ste
ni5st^^e6
n3^^eda
n3^^edsk
n1^^edu
n^^ed4um
nj^^e1l4
nk2
nk3a^^f0
nk5and
nk3ans
n5k^^e1
n1ke
nk3i
n5k^^f3
n3kunn
n5ky
n5k^^f6
n1l2
nli4
n4list.
n1m4
n2n
nn1^^e1
nn1e
nn3g2
nnk4i
nn4sj
nn5ske
nn4sto
nn5stun
nn5t^^f3
nn3ug
nn2us
nn3^^fa^^f0
n1or
1not
n5^^f3lf
5n^^f3ttin
n3p4
n1r
n3ram
n5rau
n2r4i
n3rit
n3sak
n5s^^e1t
n4seg
ns5es
ns5is
ns1^^ed
n3skil
nsk^^edr4
ns5kja
n5sk^^f6
nsn4a
ns5r
nst4e
nt3a^^f0
n5tak.
n5taki
n3tal
n1te
ntgen5
n3til
n2t^^ed
nt2s
nt5sk
nt5sm
nt3ug
nt4v
n1t^^fd
n1t^^f6
n1u
nuf4
n4ugr
nuk2
nu1l
nu1ma
5numd
nungs3
nur5f
nur4l
n3ust.
nu5sta^^f0
nu4sv
nu5ta
3n^^fam3
n^^fa4s
n1v
n5yf
n3yrk
1n^^fd
n3^^fdg
n^^fd3l
n^^fd5sk
n1^^fe
1n^^e6
n^^e6l4a
3n^^f6f
n3^^f6ld
n5^^f6n
5obs
o^^f0a3l
o^^f0r4
o^^f0s5l
o^^f04ug
o2f
of3ang
off4u
of3o
of5r
of4sj
of5su
oga3l4
ogast4
ogs4u
ok4as
olak4
old3u
ol2g
oll5eg
ol5lit
oll4st
ol3m
ol3^^f3
oltal4
o2m
om3a
om4m3
om2u
om3un
on3sv
on4t
on5t^^f3
on4us
opa5p
op2h3
op5u4
ora4
or4di
or1e
or2fe
or2gr
3or^^ed
orlag4
or2ma
or4mi
4orn
or4ne
or4sta
ortr4
ort3ug
or1u
or3ug
or3v4
or4vi^^f0
or3y
o4s
osk3i
os3m
os2s
ost5i
ost5un
4o4t
ot3a^^f0
ota5l4
otam4
ot3ro
ots4^^e1
ot5un
o4u
o3ve
ox4
^^f31a
^^f3aflat4
^^f35an
^^f3ar4s
^^f3b3ak
^^f3d4a
^^f3^^f0i4
^^f3^^f0l4
^^f3^^f0m4
^^f3^^f0v4
^^f35e
^^f3f3ar
^^f3f4as
^^f3flu5s
^^f3fr4
^^f3f5us
^^f32fy
^^f34f^^f6
^^f32g
^^f31h
^^f31i
^^f3k5lo
^^f33kr
^^f3k2u
^^f3la3m
^^f3l2as
^^f3l5ik
^^f3l4is
^^f3l4kv
^^f3l5om
3^^f3lsk
^^f34m3a^^f0
^^f3m3ar
^^f3m4b^^e6
^^f3m2g
^^f3m4is
^^f3ml4
^^f3m3p
^^f3m3stu
^^f3m3u
^^f32m^^f6
^^f34n
^^f3n3^^ed
^^f3n5kv
^^f3p4e
^^f3p2h5
^^f3r4as
^^f3r^^e14
^^f3r2d
^^f3r4d^^f6
^^f3r5es
^^f3rf4
^^f3rg4
^^f34ri
^^f3r4is
^^f3r^^edk4
^^f3rj4
^^f3rk4
^^f3rm4
^^f3rn4o
^^f3r3^^f3n
^^f3rr4
^^f3rs4a
^^f3r1u
^^f3sa5f
^^f3sak4
^^f33sem
^^f3s3end
^^f35skaf
^^f3sk4as
^^f3sk5in
^^f3s2l
^^f3slav3
^^f32s^^f3
^^f3sp4
^^f3s4se
^^f34ta
^^f3t3a^^f0
^^f3tap4
^^f3t5ef
^^f3til4t
^^f35t^^ed
^^f3t4^^f3
^^f3t2v
^^f31u
^^f3um5b
^^f3v4a
^^f35vat
^^f3y4
^^f35^^fe
p1a
pag4
pa4le
pa3m
pa4n
pan3g^^f3
pa2r
p4arat
pari3f
par5^^ed
p2art
par5te
p4aru
p2^^e1k
p4^^e1l
p^^e15m
p4^^e1r
p^^e12s
p4^^e1t
p1b
p5d
p1el
1peni
3pers
p1f2
p1g2
p1h
p1i
pil5ar
5pilt
p4ink
pist5i
pit4
3p^^edp
p^^ed2t
pl2
pl3a^^f0
pla4s
p4l^^e6
3pl^^f6
p1m4
1pok
3p^^f3s
p2p
pp5aks
pp5e
pp3^^ed
ppk4
pp1l
pp3^^f3
pp1r
ppsk4
4pra
pr2i
p4ris
pr^^ed4
3prj
1pr^^f3
pr^^f35fas
pr^^f35m
p1sa
pss4
p1st
pt2^^fa
p1u
puk4i
pu1l
pur4a
3p^^fa
p^^faf4
p1v
qu4
2ra
4ra.
5ra^^f0sh
raf4f
r3ald
ral4i
r4all
r3als
3ranal
r4ani.
3ranns
r4an^^f3
4r3ar
r4ara^^f0
r4ar^^fa
r4ary
r4ar^^e6
ras3i
ra3tu
r4aum
1r^^e1^^f0
r^^e1f4i
r^^e15kv^^e6
r^^e1rs4
r4^^e1sa
r1b4
rba4
r1d
r2d^^ed
r4^^f0
r^^f04ar4^^e1
r^^f05is
r^^f01l2
r^^f04mu
r^^f05r^^e1
r^^f05su
r^^f03sv
r^^f0v4
r4ef.
r4efs
5reftsk
1regl
r3eig
3reik
r5enu
r5eu
r4eyn
r4^^e9
r1fal2
rfa5li
rf4ar
r3f^^e1
r5fe^^f0
rf1is
r1fj
rfj^^e1r4
rf4l^^f6
rf^^f3g5
r1fr
rfr4u
rf4st
r3fund
rf4ur^^f0
rgj4a^^f0
rgj4ar
rg2l4
r5gly
r1gr
r2gra
r4grey
r5h
4ri.
4r3i^^f0.
rig2
riga5s
r3ild
4rin
rin5e
ringj5ar
r3inu
rip4s
4r3ir
ri3sk
ris5l2
3risn
rist5a^^f0
ris4un
1ri4t
rit3li
4r^^ed.
4r^^edf
r^^edkis3
4r^^edl
r^^edst4
4r^^edu
4r^^ed^^fe
rj3ar
rj^^e14l
rj^^f33sa
rj^^f3sk5a
rka1m
rkaup4s
r3k^^e1
r1ke
rk1ef
r4kell
r4kelss
rkju3s
rk4se
rk1sm
rk4sp
rk4^^fa
rk5vei
r3k^^f6
r1l2
rl3a^^f0
rl5ann
r2li4
rl4i^^f0
rlis5s
r3lit
rl3m
rlof4
rmak4
r1man
rm^^e1ls5
rmb4
rm2i
r1mi^^f0
rmil4
r5mj
rmk4
rml4
r3m^^f3^^f0
rmr4
rn3ar
rnar5l
rn1g
rn5^^f3r
rn5s^^ed
rn5sm
rn4so
r4nu
r5numi
ro4
rog4as
ron4
r1or
r^^f35gr
r^^f34m
r^^f34sa
r^^f3s3^^f3
5r^^f3ti
r5pal
r3p^^f3
r1pr
r4pri
rp2s
rp3sk
r5py
rr5ar
r1r^^e1
r1re
r1r^^e9
r1r^^ed
rr2k
r3r^^f3
rr1u
r5r^^fa
r1r^^e6
r1sa
r4saf
rs4^^e1r
rsegl4
r3ser
rs4inn
r3ske
r5skil
rs4lan
rs2m^^e1
r1st
r2sti
rst4v
r3st^^f6
rs2u
r5sund
r4s^^fa
r1sv
rt3a^^f0
rta5g
r3tak
rta4sk
r5t^^e1
rt5er
rt3ey
rt2hu
r4t^^edk
r3t^^f3
r3tr^^f6
rt4se
rt5sl
rtt4
rt4uru
rt4^^fa
r4tv
rt4ve
r1t^^e6
rt1^^f6f
r1u^^f0
r4u^^f0un
ruk4i
ru5li
ru2m
r1ur
r4uss
r3ust.
rut4v
r4^^fa^^f0
3r^^fam
r^^fast5
r1v
rv3a^^f0
r3ve
r2vi
rvi3g
rv3ing
rv4un
r3v^^e6
r3yr
1r^^fdm
r1^^fe
1r^^e6kt
r^^e6md5a
1r^^e6n
r^^e6t3i
r^^f6f4ug
r^^f6k1r
r^^f6l4
2sa.
4sab
2s3a^^f0
s4a^^f0f
1sag
4sagr
4sagt
sal5at
4s3ald
1sa2m
sam5b
4sam1e
sam3m
sam1s
sam5y
2san
s4ands
2s3ar
s4are
sarg4
s4aro
s4arp
2s1as
2sat
sat4a
2sau
s3auk
4sav
s^^e14
s3^^e1b
s5^^e1f
s^^e1lar5
s1^^e1r
s3^^e1s
s1b
s3d4
1se
2s1ef
4seld.
5semi
5sens
2ser
2ses
3set
sex3
2s1ey
s4ey^^f0
1s^^e9
s5f4
sfl4
sfr4
s1g4
sgl2
s1h
sh^^e14s
s1i
s3i^^f0.
5s4i^^f0a
s4i^^f0i
sif2
si5fi
1sig
sind4ar
sind4as
5sinnu
2s5ins
s3ir
s3ist
s4isv
si3ta
s^^ed3br
1s^^ed^^f0
s^^ed^^f0k4
s^^edgl4
s3^^edk
s^^ed4m
s^^ednk5a
s3^^edr
s1^^eds
s5^^edu.
s^^ed3v
s^^ed4ve
1sj
s3jaf
sjar4
s4j^^e1
sj^^f35l
sj^^f33m4
sj^^f33s
4sju
3sj^^fa
s2k
2sk.
4ska.
4ska^^f0
skaf4a
4skal
2skan
1ska4p
4skas
1sk^^e1
1skei
3skemm
4sken
3skey
s4k2i
2ski.
4ski^^f0
sk3inu
3skip
2skir
4skis
3sk^^edr
5skj^^e1
4sk4n
3sko^^f0
4skon
4skos
1s4kot
1sk^^f3
5sk^^f3g
1skr^^e1
4skr^^f3
3skr^^fa
4sks
sk3uri
sk3ust
2skv
1sky
3sk^^fd
1sk^^e6
sla2
sla3f
s4lam
slands5
3s4l^^e9
sl2is
s1l^^ed
s4l^^ed^^f0
s3lof
s3lok
1sl^^f3
slu3s
1slys
s3l^^e6k
s1m2
4sma
sm^^e11s
sm^^e15v
4sme
s4mek
s2mi
1sm^^ed
smj4
4sm^^f6
s2ne
3snei^^f0
5sner
s3nes
3sneyd
sn4i^^f0
sn2o
1sn^^fa
4sn^^fam
s4n^^fd
sn^^e6^^f05
1so
4sod
3son
2sor
s5or^^f0i
1s^^f34
s4^^f3l
s^^f3l3e
s^^f3l3s
2s^^f3m
s5^^f3mag
4s^^f3s
1sp2
sp^^edt3
spj4
4spl
4spra
2spr^^f3
s5pund
sr2an
s5rau
s1r^^e1
s1re
s1r^^e9
s1r^^ed
s5ro
s5r^^e6
s3r^^f6
s3s4^^e1
ss3er
ss5^^ed
s1s4k4
ssl2
ssm4
ss5or
s1st
s4stir
s1sv
s2t
2st.
s4ta
2sta.
4stal
4stap
5starfi
5starfs
4sta^^e6
1ste
3stef
3stein
5stekk
4stet
1st^^e9
st4he
4sti.
1stig
st4isl
3st^^edg
2st^^edm
4st^^edu
1stj4
4stj^^f3n
5stj^^f3r
5stj^^f6r
4stl
st3le
1sto
3stof
1st^^f3
4st^^f3n
3st^^f3r
st2r
str5al
5stranda
5strang
5straum
5str^^e1.
1stre
3str^^ed
4str^^fa
s3try
5str^^f6n
st5t
2s4tu
3stund
1st2^^fa
4stv
3st^^fd
1st^^e6
2st^^e6k
1s4t^^f6
3st^^f6^^f0
4st^^f6l
5st^^f6ng
s1u
su3f4
5sum3a
s2ung
s5upp
s5ura
sust4i
s^^fa4
s^^faln4
s5^^fan
s5^^fars
s^^fat5
sv4
4svag
4sval
s3vat
s5ve^^f0
s4vef
s2vei
s3veik
3svein
5svep
4svex
s4vi^^f0i
5svi^^f0i.
s4vik
svik3u
s5vin
s1vo
s2v^^e6
1sv^^e6^^f0
1sy
2s3yfi
3syn
4s3yr
3s4^^fd
s1^^fe
1s^^e6
4s^^e6^^f0
s^^e6f4
s^^e65fa
3s^^e6j
3s^^e6l
4s^^e6s
1s^^f6
3s^^f6g
s^^f6gu5s
2s3^^f6ld
3s^^f6m
2s3^^f6r
t2a^^f0
ta2fr
1taka
5takend
t4al.
tala4m
4tam
ta1ma
t5amt
ta4n^^e1
3tang
4tar
t4ar4a^^f0
tar5is5
tark4
tarp4
tar5s^^e1
tar^^e6v4
t1as
t4as.
ta5sl
tat4
ta4v^^ed
t4^^e14
5t^^e1kn
4t^^e1nd
t1b
t1d
4teg^^ed
5tegu
tei4
tein5g
t1eis
1tek
3tekj
tekkj5
t1end
ten5^^f3
4tepl
t3ett
2tey
t^^e94l
t3f2
tfirr4
t1g
t1h
th5ers
t1i
ti4an
ti5kis
tild4
4tin
tirk4
t4ir^^e6
tist4
t5ist.
ti3sta
tistil4
t2isv
1tit
1t^^ed
4t^^ed.
4t^^eda
3t^^ed^^f0
t^^ed4l
3t^^edm
4t^^edn
4t^^edt
t^^edv3
t4j^^f6
t1k
tk4a
t4k2i
tlaf4
t3lag
t4lag.
tl2an
tl5ann
t1l^^e1
tl2i
tlur4
t1l^^e6
2t3m4
tn2s
tnsk4
tnskr4
to4
1tog
t3on
3torg
5toru
1t^^f3m
t^^f3m3a
t^^f3m5as
5t^^f3nl
t^^f3r1
t^^f3r5au
t^^f3ri3s
t1^^f3t
t3p
tra2b
5tra^^f0ari
tr3al^^ed
tr2an
tr3ann
tr5ar
3traus
t4rey
1tr^^e9
tr4is
t5risi
t5r^^edka
3trj
t5r^^f3f
tr3^^f3tt
tr3ug
tr3una
tr5uni
1t4r^^fa
1try
t5ry^^f0
t3r^^e6n
3tr^^f6^^f0
4ts
t1sa
ts4inn
t5s^^ed
tsj4
t1sk4
ts1s
t1st4
ts4u
t2sy
tt3a^^f0
ttak4i
ttar5f
tt5^^e1
tte5r^^ed
tt5ern
t4t^^ed
tt5j
tt1l
tt1or
tt3r^^e6
tt3ug
tt4ugl
ttv4
t1t^^e6
t1u
4tu.
t4u^^f0i
tugl4
tuk4
tu3l4i^^f0
tum2
tu5min
t2ung
3t4ungl
tup4
t3ur3e
tur3k
t5urs
t4usa
t4usu
tutr4
t^^fad3
t3^^fa^^f0
t^^fa4l
1t^^fan
t^^fan4a
t1^^far
t^^fa3sk
t1v
5tveggj
t5ver
5t^^fds
t1^^fe
3t^^e6k
1t^^f6k
1t^^f6l
t5^^f6ls
2u1a
u3af
u5au
2u1^^e14
u^^e1^^e6tl4
4u1b4
4uc
4ud4
u1da
u5d^^e1
u3de
u3d^^f3
u3dr
2u^^f0a
u^^f04are
u^^f03k4
2u^^f0l
u^^f0m4
2u^^f04n
2u^^f0r
u^^f05ris
u^^f04se
u^^f03sv
u^^f05s^^e6
4u^^f0ul
2u5e
4u^^e9
4uf
uf5^^e1
ufd4
u5fit
u3fj
u1fr
u3ful
u5f^^fa
2ug
4ugal
4ugat
4uge
4ugil
4u1gj
4ugla
ug1lj
4uglu
ug4n
4ug^^f3
u5gran
4ugre
4ugrj
4ugr^^f3
ug3r^^e6
ug3ta
4ug^^f6
4u1h
4ui
u5i^^f0
4u^^ed4
2uj
2uk
ukak4
uk4as
u1ke
u5kinnin
ukku3s
u5k^^f3
u3kv
2ul
3ul.
4u1lag
ul3ar
3ulb
4ule
u5lind
ul4is
u1l^^ed
ul3k2
ul4la
4ulln
ullt4
4u3lo
u3l^^f3
ul5sv
ult4i
ul3us
ul5v4
u3l^^e6
4u1l^^f6
3um.
2uma
umak4
u1man
um4aran
2um^^e1
um^^e1l4ar
um4ba
um5b^^e6
um4b^^f6
2umd
2ume
um3ein
4umi
umj4
um4ki
4uml
umm4a
4u5mo
2um^^f3
4ump
2umr
ums4
um3sl
3umst.
um1t4
4umu
um5unn
4um^^fa
2umy
2um^^fd
2um^^e6
2um^^f6
un3ar1
unar5a
un2as
4unat
2u1nau
2un^^e1
2und
4une
4unk
2unn^^e1
4unns
2unnu
unn5ug
4uno
4un^^f3
uns4an
4unt
1unu
4unur
4un^^e6
4un^^f6
2u3o
uol4
4u^^f3
2up
upp1
upp5a
uppal5
upp4i
3ur.
2ura
ura4f
ur5a4m
ur2an
ur5anna
2ur^^e1
ur^^f0a5r^^e1
2ure
u1rek
ur3ey
4u1r^^e9
urf4a
ur3fl
urg4e
ur3gj
ur5in
4urit
4ur^^ed
u3r^^edk
ur3j4
urk4a
ur1m
ur3n^^ed
4uro
4ur^^f3
ur1sk4
ur3sna
ur4sta
ur4sv^^f6
ur5til
urt4ir
ur1u
ur4unn
4urus
ur3v4
ur4vis
4uryk
4ur^^fd
2ur^^e6
4ur^^f6
2usa
u3sal
4us4^^e1
2use
4us^^ed
2usj
4u1sk
4usl
2u3s4m
2usn
4uso
4us^^f3
4usp
u5starf
4ust^^e1
4uste
2ust^^e9
2usti
2ust^^ed
4usto
4ust^^f3
4ustr
3ustu.
2ust^^fa
4usty
4ust^^fd
4ust^^e6
4ust^^f6
u5sund
4u3sv
4usy
2us^^fd
2us^^f6
2ut
ut3a^^f0
ut2as
u3te
u5til
u3t^^f3
ut4st^^f3
ut2^^fa
u1t^^e6
2u3u
4u5^^fa
4u3v
2uy
u3yf
2u1^^fe
4u^^e6
2u5^^f6
^^fa1a
^^faal4
^^fa3arf
^^fab3an
^^fabli3
^^fa^^f03ar
^^fa^^f05g
^^fa3e
^^faf5ar
^^fafl2
^^faf5li
^^faf5ly
^^fafs4^^e1
^^fa5gala
^^fag^^f33
^^fa4g^^e6
4^^fa1i
^^fak1l
^^fakr1u
^^fak4s
^^fal5er
5^^fal4f
^^falf5al
^^fal4^^ed3
^^fal^^edp4
^^fa3lo
4^^fa2m
^^fam4r
^^fam4si
^^fa4n
^^fand4ug
^^fan4g^^f6
^^fapl5i
^^far5ef
^^far^^edt4
^^far5sl
^^far1t
^^far3un
^^far5v
^^fa3r^^e6
2^^fas
^^fa4sa
^^fas3ei
^^fas3^^ed
^^fas4sti
^^fas4sv
^^fas1v
^^fat3e
^^fat2he
^^fati5f
^^fat2is
^^fatj4
^^fat1l2
^^fat1r
4^^fa1u
^^fa1v
^^fa4va
^^fa5^^fe
v2a2
va^^f0r5
va5fo
va5h
5vallag
va4n
var4ma
varps3
var5^^fa
var4v
v3ast
va4t
3vax
ve^^f05l
ve3fe
1veg
v2ei
3vei^^f0
vein4as
5veis
4velg
2vep
v4er
1ver^^f0
ver3gj
3verk
ver2s
v^^e92
v5^^e9s
v3^^e9t5
2v3h
v2i
2vi.
v4i^^f0
5vi^^f0ar
vi^^f03l
vil4i
vi3li^^f0
3viln
vi4lo
vin3gj
4vip
3virk
visk5un
3viss
vis4v
5vita
vitk5
vit2n
4viv
4v^^edb
2v^^ed^^f0
5v^^edk
3v^^edsi
v^^edsl3a
v^^ed1v
2vn
vo3k
vol4
vork4
vor4r
4vr1
4vs
2vu
v1u^^f0
v1un
5v^^e6g
wa4
win4s4
x5ar
x2as
x3e
x3f
x5i
xis4
x^^ed3
x^^edk4
x5^^edu
xt5a^^f0
x1u4
y5ba
y^^f02s
yf5a
yf1i
yfj5a^^f0
yft4is
y1i
yj3ar
yj5^^f3
yk5e
yk3i
yk3su
yk3u
yk3v
ylf5i
ylgn4
yll5a
yl4v
ym3a
ymp5^^ed
y4n
ynj5ar
ynj3^^f3
yn4k
yn4t
yn5u
yp2us
yr5e
yr1i
yr3il
yrir3
yrj3
yrkv3a
yr2l
yr2s
yr1u
y2s
ysj3
ys2s
yst3ug
yt4h
ytil4
yt4k
y3v
^^fd5a
^^fdaf5
^^fd5^^e1
^^fd^^f02s
^^fdfl4
^^fd3flu
^^fdg4r
^^fdg4u^^f0
^^fd1i
^^fdja5f4
^^fdm4a
^^fdm4k
^^fdpru4
^^fdp2s
^^fdrf4
^^fdri3m
^^fdri5p4
^^fdr3l
^^fd4si
^^fdsig4
^^fds4l
^^fds4m
^^fd3st^^e1
^^fd5u
^^fd5^^fa
^^fd3v
^^fd5y
z^^f34
^^fe2a
^^feam4
^^fearf5a
^^fear4m
4^^feb
^^fe2i
^^feist3i
^^fej^^f34
^^feol5a
^^feor3f4
^^feor3g
^^feorm4
^^fe1^^f3l
3^^fe^^f3r
^^fe^^f3r5i
^^fe2r2
^^fera4
^^fer^^e1s4
^^feris4
^^fer^^edl4
^^fer^^ed3t
^^feru4
^^feum5a
^^feumb3
^^feur2
^^fe^^fas3
^^fe2v
^^fever5sk
^^e61b
^^e6^^f0n5
^^e6^^f0nis5
^^e6^^f02s
^^e6^^f04ug
4^^e6f
^^e6f1a
^^e64fi
^^e6f3ust
^^e6g5ist
^^e61i
^^e6j3
^^e6j4al
^^e6jark4
^^e6k1a
^^e6k1li
^^e6k3u
^^e62l
^^e6l3an
^^e6l3e
^^e6l3us
^^e6m3a
^^e6m4al
^^e64mundu
^^e6nak4
^^e6n4k
^^e6r1a
^^e6r3e
^^e6rg^^f6ng5
^^e6rif4
^^e6r3ist
^^e6ri3sv
^^e6r3l
^^e6r4n
^^e6r2s
^^e6r5un
^^e6r1us
^^e65r^^fa
^^e6s4is
^^e6t5ise
^^e6tl5i
^^e65u
^^e6va5g
^^e65val
^^e6v3ar
^^e6v4ara
^^e63ve
^^e6v3in
^^f6^^f02
^^f6^^f0l3
^^f6^^f0m5
^^f6^^f03un
^^f6^^f0v5an
^^f6^^f0v3ar
^^f61fa
^^f6fl3^^f3
^^f6fn5
^^f6fr3u
^^f6f3u
^^f64g
^^f6g3gj
^^f6ggv3
^^f6g1re
^^f6g2us
^^f6k5e
^^f6k5r^^e1
^^f6k3st
^^f6k3ul
^^f6kv3a
^^f64l
^^f6l1f4
^^f6lk2
^^f6lu5mi
^^f6l5un
^^f6l2v
^^f6lv5an
^^f6m4b
^^f6m3u
^^f6nd4l
^^f6ng5sv
^^f6ng4us
^^f6ng4v
^^f6ngv3a
^^f6nk3
^^f6nn4l
^^f6n3ug
^^f6n5un
^^f6r1e
^^f6r4ge
^^f6r4lan
^^f6rm5un
^^f6r3^^f3
^^f6r3ug
^^f6r1un
^^f6r3und
^^f6rus4
^^f6r2v
4^^f6rva
^^f6rv5al
^^f6rv5an
^^f6rv5ar
^^f6rv4i
^^f6r1y
^^f6r5^^e6
^^f64s
^^f6sk3ul
^^f6s3u
^^f6t4s
^^f63tug
^^f6t2v
^^f6tv3a
^^f65u
^^fe6^^f3
}
\egroup

