# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Crypt-OpenSSL-EC.t'

#########################

# change 'tests => 2' to 'tests => last_test_to_print';

use strict;
use warnings;

use Test::More tests => 19;
BEGIN { use_ok('Crypt::OpenSSL::EC'); use_ok('Crypt::OpenSSL::Bignum') };

my $fail = 0;
foreach my $constname (qw(
	EC_F_COMPUTE_WNAF EC_F_D2I_ECPARAMETERS EC_F_D2I_ECPKPARAMETERS
	EC_F_D2I_ECPRIVATEKEY EC_F_DO_EC_KEY_PRINT EC_F_ECKEY_PARAM2TYPE
	EC_F_ECKEY_PARAM_DECODE EC_F_ECKEY_PRIV_DECODE EC_F_ECKEY_PRIV_ENCODE
	EC_F_ECKEY_PUB_DECODE EC_F_ECKEY_PUB_ENCODE EC_F_ECKEY_TYPE2PARAM
	EC_F_ECPARAMETERS_PRINT EC_F_ECPARAMETERS_PRINT_FP
	EC_F_ECPKPARAMETERS_PRINT EC_F_ECPKPARAMETERS_PRINT_FP
	EC_F_ECP_NIST_MOD_192 EC_F_ECP_NIST_MOD_224 EC_F_ECP_NIST_MOD_256
	EC_F_ECP_NIST_MOD_521 EC_F_EC_ASN1_GROUP2CURVE
	EC_F_EC_ASN1_GROUP2FIELDID EC_F_EC_ASN1_GROUP2PARAMETERS
	EC_F_EC_ASN1_GROUP2PKPARAMETERS EC_F_EC_ASN1_PARAMETERS2GROUP
	EC_F_EC_ASN1_PKPARAMETERS2GROUP EC_F_EC_EX_DATA_SET_DATA
	EC_F_EC_GF2M_MONTGOMERY_POINT_MULTIPLY
	EC_F_EC_GF2M_SIMPLE_GROUP_CHECK_DISCRIMINANT
	EC_F_EC_GF2M_SIMPLE_GROUP_SET_CURVE EC_F_EC_GF2M_SIMPLE_OCT2POINT
	EC_F_EC_GF2M_SIMPLE_POINT2OCT
	EC_F_EC_GF2M_SIMPLE_POINT_GET_AFFINE_COORDINATES
	EC_F_EC_GF2M_SIMPLE_POINT_SET_AFFINE_COORDINATES
	EC_F_EC_GF2M_SIMPLE_SET_COMPRESSED_COORDINATES
	EC_F_EC_GFP_MONT_FIELD_DECODE EC_F_EC_GFP_MONT_FIELD_ENCODE
	EC_F_EC_GFP_MONT_FIELD_MUL EC_F_EC_GFP_MONT_FIELD_SET_TO_ONE
	EC_F_EC_GFP_MONT_FIELD_SQR EC_F_EC_GFP_MONT_GROUP_SET_CURVE
	EC_F_EC_GFP_MONT_GROUP_SET_CURVE_GFP EC_F_EC_GFP_NIST_FIELD_MUL
	EC_F_EC_GFP_NIST_FIELD_SQR EC_F_EC_GFP_NIST_GROUP_SET_CURVE
	EC_F_EC_GFP_SIMPLE_GROUP_CHECK_DISCRIMINANT
	EC_F_EC_GFP_SIMPLE_GROUP_SET_CURVE
	EC_F_EC_GFP_SIMPLE_GROUP_SET_CURVE_GFP
	EC_F_EC_GFP_SIMPLE_GROUP_SET_GENERATOR EC_F_EC_GFP_SIMPLE_MAKE_AFFINE
	EC_F_EC_GFP_SIMPLE_OCT2POINT EC_F_EC_GFP_SIMPLE_POINT2OCT
	EC_F_EC_GFP_SIMPLE_POINTS_MAKE_AFFINE
	EC_F_EC_GFP_SIMPLE_POINT_GET_AFFINE_COORDINATES
	EC_F_EC_GFP_SIMPLE_POINT_GET_AFFINE_COORDINATES_GFP
	EC_F_EC_GFP_SIMPLE_POINT_SET_AFFINE_COORDINATES
	EC_F_EC_GFP_SIMPLE_POINT_SET_AFFINE_COORDINATES_GFP
	EC_F_EC_GFP_SIMPLE_SET_COMPRESSED_COORDINATES
	EC_F_EC_GFP_SIMPLE_SET_COMPRESSED_COORDINATES_GFP EC_F_EC_GROUP_CHECK
	EC_F_EC_GROUP_CHECK_DISCRIMINANT EC_F_EC_GROUP_COPY
	EC_F_EC_GROUP_GET0_GENERATOR EC_F_EC_GROUP_GET_COFACTOR
	EC_F_EC_GROUP_GET_CURVE_GF2M EC_F_EC_GROUP_GET_CURVE_GFP
	EC_F_EC_GROUP_GET_DEGREE EC_F_EC_GROUP_GET_ORDER
	EC_F_EC_GROUP_GET_PENTANOMIAL_BASIS EC_F_EC_GROUP_GET_TRINOMIAL_BASIS
	EC_F_EC_GROUP_NEW EC_F_EC_GROUP_NEW_BY_CURVE_NAME
	EC_F_EC_GROUP_NEW_FROM_DATA EC_F_EC_GROUP_PRECOMPUTE_MULT
	EC_F_EC_GROUP_SET_CURVE_GF2M EC_F_EC_GROUP_SET_CURVE_GFP
	EC_F_EC_GROUP_SET_EXTRA_DATA EC_F_EC_GROUP_SET_GENERATOR
	EC_F_EC_KEY_CHECK_KEY EC_F_EC_KEY_COPY EC_F_EC_KEY_GENERATE_KEY
	EC_F_EC_KEY_NEW EC_F_EC_KEY_PRINT EC_F_EC_KEY_PRINT_FP
	EC_F_EC_POINTS_MAKE_AFFINE EC_F_EC_POINT_ADD EC_F_EC_POINT_CMP
	EC_F_EC_POINT_COPY EC_F_EC_POINT_DBL
	EC_F_EC_POINT_GET_AFFINE_COORDINATES_GF2M
	EC_F_EC_POINT_GET_AFFINE_COORDINATES_GFP
	EC_F_EC_POINT_GET_JPROJECTIVE_COORDINATES_GFP EC_F_EC_POINT_INVERT
	EC_F_EC_POINT_IS_AT_INFINITY EC_F_EC_POINT_IS_ON_CURVE
	EC_F_EC_POINT_MAKE_AFFINE EC_F_EC_POINT_MUL EC_F_EC_POINT_NEW
	EC_F_EC_POINT_OCT2POINT EC_F_EC_POINT_POINT2OCT
	EC_F_EC_POINT_SET_AFFINE_COORDINATES_GF2M
	EC_F_EC_POINT_SET_AFFINE_COORDINATES_GFP
	EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GF2M
	EC_F_EC_POINT_SET_COMPRESSED_COORDINATES_GFP
	EC_F_EC_POINT_SET_JPROJECTIVE_COORDINATES_GFP
	EC_F_EC_POINT_SET_TO_INFINITY EC_F_EC_PRE_COMP_DUP EC_F_EC_PRE_COMP_NEW
	EC_F_EC_WNAF_MUL EC_F_EC_WNAF_PRECOMPUTE_MULT EC_F_I2D_ECPARAMETERS
	EC_F_I2D_ECPKPARAMETERS EC_F_I2D_ECPRIVATEKEY EC_F_I2O_ECPUBLICKEY
	EC_F_O2I_ECPUBLICKEY EC_F_OLD_EC_PRIV_DECODE EC_F_PKEY_EC_CTRL
	EC_F_PKEY_EC_CTRL_STR EC_F_PKEY_EC_DERIVE EC_F_PKEY_EC_KEYGEN
	EC_F_PKEY_EC_PARAMGEN EC_F_PKEY_EC_SIGN EC_PKEY_NO_PARAMETERS
	EC_PKEY_NO_PUBKEY EC_R_ASN1_ERROR EC_R_ASN1_UNKNOWN_FIELD
	EC_R_BUFFER_TOO_SMALL EC_R_D2I_ECPKPARAMETERS_FAILURE EC_R_DECODE_ERROR
	EC_R_DISCRIMINANT_IS_ZERO EC_R_EC_GROUP_NEW_BY_NAME_FAILURE
	EC_R_FIELD_TOO_LARGE EC_R_GROUP2PKPARAMETERS_FAILURE
	EC_R_I2D_ECPKPARAMETERS_FAILURE EC_R_INCOMPATIBLE_OBJECTS
	EC_R_INVALID_ARGUMENT EC_R_INVALID_COMPRESSED_POINT
	EC_R_INVALID_COMPRESSION_BIT EC_R_INVALID_CURVE
	EC_R_INVALID_DIGEST_TYPE EC_R_INVALID_ENCODING EC_R_INVALID_FIELD
	EC_R_INVALID_FORM EC_R_INVALID_GROUP_ORDER
	EC_R_INVALID_PENTANOMIAL_BASIS EC_R_INVALID_PRIVATE_KEY
	EC_R_INVALID_TRINOMIAL_BASIS EC_R_KEYS_NOT_SET EC_R_MISSING_PARAMETERS
	EC_R_MISSING_PRIVATE_KEY EC_R_NOT_A_NIST_PRIME
	EC_R_NOT_A_SUPPORTED_NIST_PRIME EC_R_NOT_IMPLEMENTED
	EC_R_NOT_INITIALIZED EC_R_NO_FIELD_MOD EC_R_NO_PARAMETERS_SET
	EC_R_PASSED_NULL_PARAMETER EC_R_PKPARAMETERS2GROUP_FAILURE
	EC_R_POINT_AT_INFINITY EC_R_POINT_IS_NOT_ON_CURVE EC_R_SLOT_FULL
	EC_R_UNDEFINED_GENERATOR EC_R_UNDEFINED_ORDER EC_R_UNKNOWN_GROUP
	EC_R_UNKNOWN_ORDER EC_R_UNSUPPORTED_FIELD EC_R_WRONG_ORDER
	EVP_PKEY_CTRL_EC_PARAMGEN_CURVE_NID OPENSSL_ECC_MAX_FIELD_BITS
	OPENSSL_EC_NAMED_CURVE POINT_CONVERSION_COMPRESSED
	POINT_CONVERSION_HYBRID POINT_CONVERSION_UNCOMPRESSED)) {
  next if (eval "my \$a = $constname; 1");
  if ($@ =~ /^Your vendor has not defined Crypt::OpenSSL::EC macro $constname/) {
    print "# pass: $@";
  } else {
    print "# fail: $@";
    $fail = 1;
  }

}

ok( $fail == 0 , 'Constants' );
#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

# Exercise basic creation and destruction code:

my $method = Crypt::OpenSSL::EC::EC_GFp_mont_method();
ok($method);
$method = Crypt::OpenSSL::EC::EC_GFp_mont_method();
ok($method);

my $group = Crypt::OpenSSL::EC::EC_GROUP::new($method);
$group = Crypt::OpenSSL::EC::EC_GROUP::new($method);
ok($group);

my $point = Crypt::OpenSSL::EC::EC_POINT::new($group);
ok($point);
$point = Crypt::OpenSSL::EC::EC_POINT::new($group);
ok($point);

my $key = Crypt::OpenSSL::EC::EC_KEY::new();
ok($key);
$key = Crypt::OpenSSL::EC::EC_KEY::new();
ok($key);

my $bignum = $key->get0_private_key();
ok($bignum);

$group = $key->get0_group();
ok($group);

$point = $key->get0_public_key();
ok($point);

my $nid   = 415;        # NID_X9_62_prime256v1
$group = Crypt::OpenSSL::EC::EC_GROUP::new_by_curve_name($nid);
my $ctx   = Crypt::OpenSSL::Bignum::CTX->new();
my $order = Crypt::OpenSSL::Bignum->zero;
$group->get_order( $order, $ctx );
my $eckey = Crypt::OpenSSL::EC::EC_KEY::new();
ok($eckey);
ok($eckey->set_group($group));
ok($eckey->generate_key());
$bignum = $eckey->get0_private_key();
ok($bignum);
#print '$bignum ', $bignum, "\n";
my $binary = $bignum->to_bin;
ok($binary);
my $K = $eckey->get0_public_key();
ok($K);
#print '$K: ', $K, "\n";
