######################################################################
#
# 0117_cp932_vs_cp932x_test.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);

    use Jacode4e;

    for my $row (0x81..0x9F, 0xE0..0xFC) {
        for my $cell (0x40..0x7E, 0x80..0xFC) {
            my $cp932_hex  = sprintf('%c%c', $row, $cell);
            my $cp932x_hex = sprintf('%c%c', $row, $cell);
            if ($cp932_hex =~ /^\x81\xAC$/) {
                push @test, [$cp932_hex,'cp932x','cp932',{'INPUT_LAYOUT'=>'D'}, $cp932x_hex],
            }
            elsif ($cp932_hex =~ /^\x9C\x5A$/) {
            }
            elsif ($cp932_hex =~ m'^(?:
    \x81\xBE|\x81\xBF|\x81\xCA|\x81\xDA|\x81\xDB|\x81\xDF|\x81\xE0|\x81\xE3|\x81\xE6|\x81\xE7|
    \x87\x54|\x87\x55|\x87\x56|\x87\x57|\x87\x58|\x87\x59|\x87\x5A|\x87\x5B|\x87\x5C|\x87\x5D|
    \x87\x82|\x87\x84|\x87\x8A|\x87\x90|\x87\x91|\x87\x92|\x87\x95|\x87\x96|\x87\x97|\x87\x9A|
    \x87\x9B|\x87\x9C|\xED\x40|\xED\x41|\xED\x42|\xED\x43|\xED\x44|\xED\x45|\xED\x46|\xED\x47|
    \xED\x48|\xED\x49|\xED\x4A|\xED\x4B|\xED\x4C|\xED\x4D|\xED\x4E|\xED\x4F|\xED\x50|\xED\x51|
    \xED\x52|\xED\x53|\xED\x54|\xED\x55|\xED\x56|\xED\x57|\xED\x58|\xED\x59|\xED\x5A|\xED\x5B|
    \xED\x5C|\xED\x5D|\xED\x5E|\xED\x5F|\xED\x60|\xED\x61|\xED\x62|\xED\x63|\xED\x64|\xED\x65|
    \xED\x66|\xED\x67|\xED\x68|\xED\x69|\xED\x6A|\xED\x6B|\xED\x6C|\xED\x6D|\xED\x6E|\xED\x6F|
    \xED\x70|\xED\x71|\xED\x72|\xED\x73|\xED\x74|\xED\x75|\xED\x76|\xED\x77|\xED\x78|\xED\x79|
    \xED\x7A|\xED\x7B|\xED\x7C|\xED\x7D|\xED\x7E|\xED\x80|\xED\x81|\xED\x82|\xED\x83|\xED\x84|
    \xED\x85|\xED\x86|\xED\x87|\xED\x88|\xED\x89|\xED\x8A|\xED\x8B|\xED\x8C|\xED\x8D|\xED\x8E|
    \xED\x8F|\xED\x90|\xED\x91|\xED\x92|\xED\x93|\xED\x94|\xED\x95|\xED\x96|\xED\x97|\xED\x98|
    \xED\x99|\xED\x9A|\xED\x9B|\xED\x9C|\xED\x9D|\xED\x9E|\xED\x9F|\xED\xA0|\xED\xA1|\xED\xA2|
    \xED\xA3|\xED\xA4|\xED\xA5|\xED\xA6|\xED\xA7|\xED\xA8|\xED\xA9|\xED\xAA|\xED\xAB|\xED\xAC|
    \xED\xAD|\xED\xAE|\xED\xAF|\xED\xB0|\xED\xB1|\xED\xB2|\xED\xB3|\xED\xB4|\xED\xB5|\xED\xB6|
    \xED\xB7|\xED\xB8|\xED\xB9|\xED\xBA|\xED\xBB|\xED\xBC|\xED\xBD|\xED\xBE|\xED\xBF|\xED\xC0|
    \xED\xC1|\xED\xC2|\xED\xC3|\xED\xC4|\xED\xC5|\xED\xC6|\xED\xC7|\xED\xC8|\xED\xC9|\xED\xCA|
    \xED\xCB|\xED\xCC|\xED\xCD|\xED\xCE|\xED\xCF|\xED\xD0|\xED\xD1|\xED\xD2|\xED\xD3|\xED\xD4|
    \xED\xD5|\xED\xD6|\xED\xD7|\xED\xD8|\xED\xD9|\xED\xDA|\xED\xDB|\xED\xDC|\xED\xDD|\xED\xDE|
    \xED\xDF|\xED\xE0|\xED\xE1|\xED\xE2|\xED\xE3|\xED\xE4|\xED\xE5|\xED\xE6|\xED\xE7|\xED\xE8|
    \xED\xE9|\xED\xEA|\xED\xEB|\xED\xEC|\xED\xED|\xED\xEE|\xED\xEF|\xED\xF0|\xED\xF1|\xED\xF2|
    \xED\xF3|\xED\xF4|\xED\xF5|\xED\xF6|\xED\xF7|\xED\xF8|\xED\xF9|\xED\xFA|\xED\xFB|\xED\xFC|
    \xEE\x40|\xEE\x41|\xEE\x42|\xEE\x43|\xEE\x44|\xEE\x45|\xEE\x46|\xEE\x47|\xEE\x48|\xEE\x49|
    \xEE\x4A|\xEE\x4B|\xEE\x4C|\xEE\x4D|\xEE\x4E|\xEE\x4F|\xEE\x50|\xEE\x51|\xEE\x52|\xEE\x53|
    \xEE\x54|\xEE\x55|\xEE\x56|\xEE\x57|\xEE\x58|\xEE\x59|\xEE\x5A|\xEE\x5B|\xEE\x5C|\xEE\x5D|
    \xEE\x5E|\xEE\x5F|\xEE\x60|\xEE\x61|\xEE\x62|\xEE\x63|\xEE\x64|\xEE\x65|\xEE\x66|\xEE\x67|
    \xEE\x68|\xEE\x69|\xEE\x6A|\xEE\x6B|\xEE\x6C|\xEE\x6D|\xEE\x6E|\xEE\x6F|\xEE\x70|\xEE\x71|
    \xEE\x72|\xEE\x73|\xEE\x74|\xEE\x75|\xEE\x76|\xEE\x77|\xEE\x78|\xEE\x79|\xEE\x7A|\xEE\x7B|
    \xEE\x7C|\xEE\x7D|\xEE\x7E|\xEE\x80|\xEE\x81|\xEE\x82|\xEE\x83|\xEE\x84|\xEE\x85|\xEE\x86|
    \xEE\x87|\xEE\x88|\xEE\x89|\xEE\x8A|\xEE\x8B|\xEE\x8C|\xEE\x8D|\xEE\x8E|\xEE\x8F|\xEE\x90|
    \xEE\x91|\xEE\x92|\xEE\x93|\xEE\x94|\xEE\x95|\xEE\x96|\xEE\x97|\xEE\x98|\xEE\x99|\xEE\x9A|
    \xEE\x9B|\xEE\x9C|\xEE\x9D|\xEE\x9E|\xEE\x9F|\xEE\xA0|\xEE\xA1|\xEE\xA2|\xEE\xA3|\xEE\xA4|
    \xEE\xA5|\xEE\xA6|\xEE\xA7|\xEE\xA8|\xEE\xA9|\xEE\xAA|\xEE\xAB|\xEE\xAC|\xEE\xAD|\xEE\xAE|
    \xEE\xAF|\xEE\xB0|\xEE\xB1|\xEE\xB2|\xEE\xB3|\xEE\xB4|\xEE\xB5|\xEE\xB6|\xEE\xB7|\xEE\xB8|
    \xEE\xB9|\xEE\xBA|\xEE\xBB|\xEE\xBC|\xEE\xBD|\xEE\xBE|\xEE\xBF|\xEE\xC0|\xEE\xC1|\xEE\xC2|
    \xEE\xC3|\xEE\xC4|\xEE\xC5|\xEE\xC6|\xEE\xC7|\xEE\xC8|\xEE\xC9|\xEE\xCA|\xEE\xCB|\xEE\xCC|
    \xEE\xCD|\xEE\xCE|\xEE\xCF|\xEE\xD0|\xEE\xD1|\xEE\xD2|\xEE\xD3|\xEE\xD4|\xEE\xD5|\xEE\xD6|
    \xEE\xD7|\xEE\xD8|\xEE\xD9|\xEE\xDA|\xEE\xDB|\xEE\xDC|\xEE\xDD|\xEE\xDE|\xEE\xDF|\xEE\xE0|
    \xEE\xE1|\xEE\xE2|\xEE\xE3|\xEE\xE4|\xEE\xE5|\xEE\xE6|\xEE\xE7|\xEE\xE8|\xEE\xE9|\xEE\xEA|
    \xEE\xEB|\xEE\xEC|\xEE\xEF|\xEE\xF0|\xEE\xF1|\xEE\xF2|\xEE\xF3|\xEE\xF4|\xEE\xF5|\xEE\xF6|
    \xEE\xF7|\xEE\xF8|\xEE\xF9|\xEE\xFA|\xEE\xFB|\xEE\xFC|\xFA\x40|\xFA\x41|\xFA\x42|\xFA\x43|
    \xFA\x44|\xFA\x45|\xFA\x46|\xFA\x47|\xFA\x48|\xFA\x49|\xFA\x4A|\xFA\x4B|\xFA\x4C|\xFA\x4D|
    \xFA\x4E|\xFA\x4F|\xFA\x50|\xFA\x51|\xFA\x52|\xFA\x53|\xFA\x54|\xFA\x55|\xFA\x56|\xFA\x57|
    \xFA\x58|\xFA\x59|\xFA\x5A|\xFA\x5B|\xFA\x5C|\xFA\x5D|\xFA\x5E|\xFA\x5F|\xFA\x60|\xFA\x61|
    \xFA\x62|\xFA\x63|\xFA\x64|\xFA\x65|\xFA\x66|\xFA\x67|\xFA\x68|\xFA\x69|\xFA\x6A|\xFA\x6B|
    \xFA\x6C|\xFA\x6D|\xFA\x6E|\xFA\x6F|\xFA\x70|\xFA\x71|\xFA\x72|\xFA\x73|\xFA\x74|\xFA\x75|
    \xFA\x76|\xFA\x77|\xFA\x78|\xFA\x79|\xFA\x7A|\xFA\x7B|\xFA\x7C|\xFA\x7D|\xFA\x7E|\xFA\x80|
    \xFA\x81|\xFA\x82|\xFA\x83|\xFA\x84|\xFA\x85|\xFA\x86|\xFA\x87|\xFA\x88|\xFA\x89|\xFA\x8A|
    \xFA\x8B|\xFA\x8C|\xFA\x8D|\xFA\x8E|\xFA\x8F|\xFA\x90|\xFA\x91|\xFA\x92|\xFA\x93|\xFA\x94|
    \xFA\x95|\xFA\x96|\xFA\x97|\xFA\x98|\xFA\x99|\xFA\x9A|\xFA\x9B|\xFA\x9C|\xFA\x9D|\xFA\x9E|
    \xFA\x9F|\xFA\xA0|\xFA\xA1|\xFA\xA2|\xFA\xA3|\xFA\xA4|\xFA\xA5|\xFA\xA6|\xFA\xA7|\xFA\xA8|
    \xFA\xA9|\xFA\xAA|\xFA\xAB|\xFA\xAC|\xFA\xAD|\xFA\xAE|\xFA\xAF|\xFA\xB0|\xFA\xB1|\xFA\xB2|
    \xFA\xB3|\xFA\xB4|\xFA\xB5|\xFA\xB6|\xFA\xB7|\xFA\xB8|\xFA\xB9|\xFA\xBA|\xFA\xBB|\xFA\xBC|
    \xFA\xBD|\xFA\xBE|\xFA\xBF|\xFA\xC0|\xFA\xC1|\xFA\xC2|\xFA\xC3|\xFA\xC4|\xFA\xC5|\xFA\xC6|
    \xFA\xC7|\xFA\xC8|\xFA\xC9|\xFA\xCA|\xFA\xCB|\xFA\xCC|\xFA\xCD|\xFA\xCE|\xFA\xCF|\xFA\xD0|
    \xFA\xD1|\xFA\xD2|\xFA\xD3|\xFA\xD4|\xFA\xD5|\xFA\xD6|\xFA\xD7|\xFA\xD8|\xFA\xD9|\xFA\xDA|
    \xFA\xDB|\xFA\xDC|\xFA\xDD|\xFA\xDE|\xFA\xDF|\xFA\xE0|\xFA\xE1|\xFA\xE2|\xFA\xE3|\xFA\xE4|
    \xFA\xE5|\xFA\xE6|\xFA\xE7|\xFA\xE8|\xFA\xE9|\xFA\xEA|\xFA\xEB|\xFA\xEC|\xFA\xED|\xFA\xEE|
    \xFA\xEF|\xFA\xF0|\xFA\xF1|\xFA\xF2|\xFA\xF3|\xFA\xF4|\xFA\xF5|\xFA\xF6|\xFA\xF7|\xFA\xF8|
    \xFA\xF9|\xFA\xFA|\xFA\xFB|\xFA\xFC|\xFB\x40|\xFB\x41|\xFB\x42|\xFB\x43|\xFB\x44|\xFB\x45|
    \xFB\x46|\xFB\x47|\xFB\x48|\xFB\x49|\xFB\x4A|\xFB\x4B|\xFB\x4C|\xFB\x4D|\xFB\x4E|\xFB\x4F|
    \xFB\x50|\xFB\x51|\xFB\x52|\xFB\x53|\xFB\x54|\xFB\x55|\xFB\x56|\xFB\x57|\xFB\x58|\xFB\x59|
    \xFB\x5A|\xFB\x5B|\xFB\x5C|\xFB\x5D|\xFB\x5E|\xFB\x5F|\xFB\x60|\xFB\x61|\xFB\x62|\xFB\x63|
    \xFB\x64|\xFB\x65|\xFB\x66|\xFB\x67|\xFB\x68|\xFB\x69|\xFB\x6A|\xFB\x6B|\xFB\x6C|\xFB\x6D|
    \xFB\x6E|\xFB\x6F|\xFB\x70|\xFB\x71|\xFB\x72|\xFB\x73|\xFB\x74|\xFB\x75|\xFB\x76|\xFB\x77|
    \xFB\x78|\xFB\x79|\xFB\x7A|\xFB\x7B|\xFB\x7C|\xFB\x7D|\xFB\x7E|\xFB\x80|\xFB\x81|\xFB\x82|
    \xFB\x83|\xFB\x84|\xFB\x85|\xFB\x86|\xFB\x87|\xFB\x88|\xFB\x89|\xFB\x8A|\xFB\x8B|\xFB\x8C|
    \xFB\x8D|\xFB\x8E|\xFB\x8F|\xFB\x90|\xFB\x91|\xFB\x92|\xFB\x93|\xFB\x94|\xFB\x95|\xFB\x96|
    \xFB\x97|\xFB\x98|\xFB\x99|\xFB\x9A|\xFB\x9B|\xFB\x9C|\xFB\x9D|\xFB\x9E|\xFB\x9F|\xFB\xA0|
    \xFB\xA1|\xFB\xA2|\xFB\xA3|\xFB\xA4|\xFB\xA5|\xFB\xA6|\xFB\xA7|\xFB\xA8|\xFB\xA9|\xFB\xAA|
    \xFB\xAB|\xFB\xAC|\xFB\xAD|\xFB\xAE|\xFB\xAF|\xFB\xB0|\xFB\xB1|\xFB\xB2|\xFB\xB3|\xFB\xB4|
    \xFB\xB5|\xFB\xB6|\xFB\xB7|\xFB\xB8|\xFB\xB9|\xFB\xBA|\xFB\xBB|\xFB\xBC|\xFB\xBD|\xFB\xBE|
    \xFB\xBF|\xFB\xC0|\xFB\xC1|\xFB\xC2|\xFB\xC3|\xFB\xC4|\xFB\xC5|\xFB\xC6|\xFB\xC7|\xFB\xC8|
    \xFB\xC9|\xFB\xCA|\xFB\xCB|\xFB\xCC|\xFB\xCD|\xFB\xCE|\xFB\xCF|\xFB\xD0|\xFB\xD1|\xFB\xD2|
    \xFB\xD3|\xFB\xD4|\xFB\xD5|\xFB\xD6|\xFB\xD7|\xFB\xD8|\xFB\xD9|\xFB\xDA|\xFB\xDB|\xFB\xDC|
    \xFB\xDD|\xFB\xDE|\xFB\xDF|\xFB\xE0|\xFB\xE1|\xFB\xE2|\xFB\xE3|\xFB\xE4|\xFB\xE5|\xFB\xE6|
    \xFB\xE7|\xFB\xE8|\xFB\xE9|\xFB\xEA|\xFB\xEB|\xFB\xEC|\xFB\xED|\xFB\xEE|\xFB\xEF|\xFB\xF0|
    \xFB\xF1|\xFB\xF2|\xFB\xF3|\xFB\xF4|\xFB\xF5|\xFB\xF6|\xFB\xF7|\xFB\xF8|\xFB\xF9|\xFB\xFA|
    \xFB\xFB|\xFB\xFC|\xFC\x40|\xFC\x41|\xFC\x42|\xFC\x43|\xFC\x44|\xFC\x45|\xFC\x46|\xFC\x47|
    \xFC\x48|\xFC\x49|\xFC\x4A|\xFC\x4B
            )$'x) {
            }
            else {
                my $got = 
                $cp932_hex;
                if (Jacode4e::convert(\$got,'cp932','cp932',{'INPUT_LAYOUT'=>'D'})) {
                    if ($got ne "\x81\xAC") {
                        push @test, [$cp932_hex,'cp932x','cp932',{'INPUT_LAYOUT'=>'D'}, $cp932x_hex],
                    }
                }
            }
        }
    }
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'},}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'},}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]},} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]},}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
