use strict;
use warnings;
use Test::More;
use Digest::Keccak qw(keccak_512 keccak_512_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::Keccak->new(512)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            keccak_512_hex($data), $digest,
            "keccak_512_hex: $len bits of $msg"
        );
        ok(
            keccak_512($data) eq pack('H*', $digest),
            "keccak_512: $len bits of $msg"
        );
    }

    my $md = Digest::Keccak->new(512)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

done_testing;

__DATA__
00|0EAB42DE4C3CEB9235FC91ACFFE746B29C29A8C366B7C60E4E67C466F36A4304C00FA9CAF9D87976BA469BCBE06713B435F091EF2769FB160CDAB33D3670680E
00|7D9025BB145A0814083E934BAA80EDE67322651DE52062BF9EB93623C37EFC74C62240CF8539107F9210C1E1126F79CBAEDA6B82B4A8CE6821589C403FA76B9A
C0|0AE7DAC687C3525D5C2A6C4119EA3968D43DFE69C2407A44D3DE6B804D784530462440E4881FD42785E1CB69AF4F036D96D8FF1EE35D9B3FA4A2859F592FB2DC
C0|5A844DE7D6B8BE77BEC55021C9BFA375C4B97D79633C7EA4E7E2BC4C64AC6349D3A0142AAA50C2118B1D94AF9A5B804AF94F259B2D06C3F4A4997AFB8F787F6B
80|B9F236B9C7CA24FE356E9375B34831B0054D4AB5CFB9E326C9E411C1805B3ADB36E7D6CECCAC123F27638FAD3F34C48F8813A338CD53824D19BC14F6EAC218B6
48|88CD5E4AB2B5CC16CF48E87B1EE3EE1FC5B1EA98142E02346429E5C8F18B570120A04040CDAB16643BFD70D31AB3FD6FC360955AB4F6A9494F4FDFAA9B6576B2
50|5C69CFB002435D627390C62F2E7E74A688E537EA1DAC71D97F6D99BCCB64FDA7D45A8E6B9DAC199B78C4A3B59B04C8F1354B8D15B01DB520932F1544DFBF757B
98|90E09885B5F8B9192E8380522F96D6C1C6D407AA9B73CB07AD8B84C310F08ADAD507B63C2C041F00119062D63421FFB51E81D39DB17A022730A03D6FEECBCF0B
CC|8630C13CBD066EA74BBE7FE468FEC1DEE10EDC1254FB4C1B7C5FD69B646E44160B8CE01D05A0908CA790DFB080F4B513BC3B6225ECE7A810371441A5AC666EB9
9800|BB1BB51EAA5733F3788703E89C5ED2290FB69DBB9184B79484B0CAA3FC7B423B6C625DDCC447D3E38E90ED02F1D9A41D87AD4BC4BEF1E61EA07B40AD3027B065
9D40|98A010E27C158551048CD5A129A41D0DDAAF88F80F4F055376E86604FAC5AA22D5237A2C72E72E85B801095F78E2980C4BF77CA7B976DFEDA05CA1A60B23DFAE
AA80|55E7507AB43B7CC1C68E6BA5D343D48F2696BD318C16503DF133F1CAC09A3535419903D50370D82FB93F60A76D17F9B4EBA308C37AF850912986A3DA17E6E75C
9830|E3063A882573859E32017A6CCFB57B987C6F6FEA20D549E333DEA845A7386B85A25B9E8333B3FDB4B54059E5777A46D327C4E468BD10165302BB31C2AF8611C1
5030|4398A50AE4A6FADD7F5F8E6A7081F8009680957861F3B3A53D54B7F4CEA148B7EDBF9A1AC147A5DBAF7D4CD94A728C76A2398E8AA4CD5FD84CDB9867DD88F5A0
4D24|6F4B8760DFC6562DE01B2B143A52ADC17BE4BA0E204384975C7CF57B7003318D3A7572A4168A399D0196BA5F7C7CC0A9D2BC9E60533F035EE2F9DDA8179BC87C
CBDE|0B8690ABB5CB59D642C70D133576E23239B2056C20DF86A3CB7E3FC19CF01C2E093EBB3D784280B9D76187B350C1D429CF2AD3E36110B58CE0C1D73D05FCFE59
41FB|551DA6236F8B96FCE9F97F1190E901324F0B45E06DBBB5CDB8355D6ED1DC34B3F0EAE7DCB68622FF232FA3CECE0D4616CDEB3931F93803662A28DF1CD535B731
4FF400|0528A7C3B8D8CC33356F6939CF6B1F3735D1F2A79082AABB68B7BAF9DECEE1D294B4000A38D0D9633C12D0A79B029986769164B39A074A73868EDE1C76B67C3B
FD0440|E63FEC3C66851679AED870E79F9FBF1357193A15AEF7C1AC8539E364AF96EDB9E35BBF2584B5C58AF375923A2BEC13FD6AE3E9B0A65312A2DFFD85C56B81CE77
424D00|80D1E59DCA8652A4A4D3AD1ED538ED51F96BB424821D442B2287C6860F4AEB061D61BDB0D2B93CA2A90F704C748739C3D631978C32AAC5B0BF761E5DF1C4723A
3FDEE0|5E101A1EB7E889DF3E87F59DCD4936D22032F99B2F7FC3BFAA21C0D7C5802C1444858EE021129C2F84085420434AC072F0033950FD1AD5F650D28EF78D40C453
335768|63619316318E0C2EAF7A5BF4F05098845AD1FF57E3C6DC43B2F661A12FC4C86ED08F39C9B53CB4703E8D3A7F1738BA1E901A2A736E97FB94CF347471AD45B589
051E7C|0879FE1C91F39A3292AE8821A8FA436A0817FCCE04D36B27718CD9BDFBF0B35B3100233AB78160891DFD800BD48F5ED69290A22C630081BE4A23CA22C86AAF19
717F8C|74C5354A9033D668DCE7E77AA3514FC5DEEAC273796A3E8FF9AE88509D875CFCCDDAE2AE6621BAF9F2C42AF85A551A3A5ACE367FAA66985C9DF41B9D8CE4CADF
1F877C|EB7F2A98E00AF37D964F7D8C44C1FB6E114D8EE21A7B976AE736539EFDC1E3FE43BECEF5015171E6DA30168CAE99A82C53FA99042774EF982C01626A540F08C0
EB35CF80|65AFF5A084AB8DEFA66462AF43A484615E8A57D647F7C11207629CF33AF0F74510F67325E2DB82BED15F82E6AD6CB117751C8C24A8A512344F1E90D853047A7F
B406C480|6010233523D0AE072D9C4D679EAF58A2B72BD7C9ED5FA24757C1AEEBC796A67DFC47CF40B1D92B0662F36470A2E20A17025F9B69A91F0013404AD98C4BA97759
CEE88040|662C4988BEBF656B1C3172C8AC2BCA4272C15ACE4EF6AFF5799F24024794AFD2F0C6171E0EABB2FA745A59B332D83809D288CBD7E534D686BCAA1F5F03DBF3DE
C584DB70|88A012017C444FB01525D25CE726370273DB8D6E2F1CE840C845F692B2DB637AFCDE7B665793F9EA088D922FFC3475CCBCDC0DA9D8722D2863C614D1A29A4D5A
53587BC8|1C1277080E9B8E33743FE90B6C7F48520383CF27138538F99EE3102C4F0332CEBD446BE464660341234026FE3AAE6E22135CB8F9A3D4BA8045F0DF62C9C8F15B
69A305B0|FBC3AAD0839B152256C44E61D24FE7ED33ACCCF94DC6ED2162F81C847731F8EF78EA9AB848222E9B0032B1A0FD4131D81C77C82F99254DE892793AE28D13E20E
C9375ECE|881FA997CCBE7AF73EC93AC192D96A6CCFE8CD4814EE2825D248DC4AC411FC9B32C5C031B1AE9773FF5CA9D480B6D4F73F9272C9224A6802F9AB77F98731A89D
C1ECFDFC|952D4C0A6F0EF5CE438C52E3EDD345EA00F91CF5DA8097C1168A16069E958FC05BAD90A0C5FB4DD9EC28E84B226B94A847D6BB89235692EF4C9712F0C7030FAE
8D73E8A280|DAFBEAFA4034C7CA0CB3616309493C92F9D4A386E7BF3950A6BBCEEE9E2C6DAA64A105ABD2EAC31539B8CECCE07E572F6263BEE2D9716DBC664A6330C8593DB5
06F2522080|42E83D86A46BBC79F8F0D0FE0CD66FA0B8B7F01BB2DBD67D29B60DD1C176D354AC0B21B38376453D867260F452CBFC4034E608426D5C03E6D97C53798BD6EFBE
3EF6C36F20|6E0A75D1B4D96664EEF8A1FFC9D086C67C9477494FA9BB1760121B72588F604931F4790EEE494C45E407209996020963BCAEBDFFBAA8DEB6C3A0A38848861A1B
0127A1D340|A6DFD9AF0FCBAA17A81F0D7CE4C4B445FD17B41D65F8F383C3BD67EE1975988E111F21C42D81B05A7176BF6301611F5FC5CE51945B1CCC966A0E9DEB95634DDA
6A6AB6C210|BB8BB7FEF46CCC2A01500091A1DEF056B6BBA4F76AC67E805F69EE2293C9A00584D37D621ACE8F5B9B8E2120CEA60D8C335A517097DD443C6FAAA5061F38394E
AF3175E160|8BC73B4EA3B33277742686FAB0A3658B0B9916E4D1F97C5E67645622F81E940FA709D3A70E78BA97490F78BE15F442EAE83A0D48F78F305DF21DC4C223BF1697
B66609ED86|EC5DF3541923F8F665C9711C4FCAA13F5822F62B10F27EFA903487B7EAD98A796BE85F001B143C25A8986999E792FDF4220952492BCA5FEAFDDF30C2962B8DA5
21F134AC57|2E76D93AFFD62B92FC4F29CB83EFBE4BA21D88426AA7F075BFC20960EA258787898172E17045AF43AB1FE445532BE0185FBEA84D9BE788B05F14DBF4856A5254
3DC2AADFFC80|0DBA3F750E3C2F725CC477D9CB63F4FE12076DA6F3F1FA8F3042C69D1E4EF6CFB040673846FEBDB28744E6C6E0105D78DF6109095E3AAA31FA1F93279C9CD912
9202736D2240|D53E12B614DFB8F42D3BD9A2A5544A99E4AB269E9AD636995FA1E440941570C77622254C1C863096FD68FF9DCFBEBF85E65593801714B2E4AC24B20FCB8A5408
F219BD629820|4054B513A17173083AEDE6E4CC629B0F17315885D04E134401D189019B6033AC0C8667DCBB200621F3D58BE99EA277161F706FC519971D807B7DAA62E5D5A795
F3511EE2C4B0|1C5EC67F5E1DDFAABC16DC78DCA9C33D3078DFA95275D61A6354DA8935699C4B4F5C768E879ED29F3AB91C84248635492A2BE6A64294B6622CE8B68DC4ADC215
3ECAB6BF7720|85F15FA8F5559E7A235135E34E4DA4BB83B701C2B60C225EF9BA40B1F6B159A081CC06CF6E643CEE585A4234D9869F18B3CD3E14866C9C8C2AAFAC21C7BC220C
CD62F688F498|6E1EEE3796FF169B6E6D4474337DBB9B445DA04A4FDAD95B5BFF7688A2827F8787F270BAA8EC5EEB7F638C62C42FA8CE711F7CC666A0B3EAC8DEAE230FD94D57
C2CBAA33A9F8|5387B52BC1DB2110AA1C9E1AE438CF98596B32061CD7DBE5EF3468B92E7482702D6C6A1AC01D657F07E50067F036C03B76A1B85AEE4D6DD57367312589C54EA1
C6F50BB74E29|40FA8074E1E509B206448FBE757D9494B9B51E8D6E674A67F53C11EF92E96C3EA08B95EBD4172B020010CD6CF29539A34D6BFA002A2042787AA8D879A0F5B54C
79F1B4CCC62A00|7C6C8573F5142730C74EF22725CAA16E713EA20F7DAB9D9BC5E1B7BC4638AC0BCAF4E6B589708CD74F1C3A998A2451E3E9BBDC8658590ACC58D173E82D1329AD
