# WWW-Docker

Perl client for the Docker Engine API.

## Description

WWW::Docker is a pure Perl client for the Docker Engine API. It provides a clean object-oriented interface to manage Docker containers, images, networks, and volumes without the overhead of heavy HTTP client libraries.

### Key Features

- **Pure Perl implementation** with minimal dependencies (no LWP)
- **Unix socket and TCP transport** support
- **Automatic API version negotiation** with Docker daemon
- **Object-oriented entity classes** (Container, Image, Network, Volume)
- **HTTP/1.1 implementation** with chunked transfer encoding
- **Comprehensive logging** via Log::Any

## Installation

```bash
cpanm WWW::Docker
```

Or from source:

```bash
dzil build
dzil test
dzil install
```

## Synopsis

```perl
use WWW::Docker;

# Connect to local Docker daemon via Unix socket
my $docker = WWW::Docker->new;

# Or connect to remote Docker daemon
my $docker = WWW::Docker->new(
    host => 'tcp://192.168.1.100:2375',
);

# System information
my $info = $docker->system->info;
my $version = $docker->system->version;

# Container management
my $containers = $docker->containers->list(all => 1);
my $result = $docker->containers->create(
    Image => 'nginx:latest',
    name  => 'my-nginx',
);
$docker->containers->start($result->{Id});

# Image operations
$docker->images->pull(fromImage => 'nginx', tag => 'latest');
my $images = $docker->images->list;

# Network and volume management
my $networks = $docker->networks->list;
my $volumes = $docker->volumes->list;
```

## Documentation

Full documentation is available on [CPAN](https://metacpan.org/pod/WWW::Docker).

## Architecture

The distribution is organized into several layers:

- **Main Client** - `WWW::Docker` - Entry point with API version negotiation
- **API Modules** - Resource-specific API methods (System, Containers, Images, Networks, Volumes, Exec)
- **Entity Classes** - Object wrappers for Docker resources (Container, Image, Network, Volume)
- **HTTP Role** - `WWW::Docker::Role::HTTP` - HTTP transport layer over Unix/TCP sockets

## Environment Variables

- `DOCKER_HOST` - Docker daemon connection URL (default: `unix:///var/run/docker.sock`)
- `DOCKER_CERT_PATH` - Path to TLS certificates directory

## Repository

- **GitHub**: https://github.com/Getty/p5-www-docker
- **CPAN**: https://metacpan.org/release/WWW-Docker

## Author

Torsten Raudssus <torsten@raudssus.de>

## Copyright and License

This software is copyright (c) 2025 by Torsten Raudssus.

This is free software; you can redistribute it and/or modify it under the same terms as the Perl 5 programming language system itself.
