# Generated by default/object.tt
package Paws::WAFV2::Rule;
  use Moose;
  has Action => (is => 'ro', isa => 'Paws::WAFV2::RuleAction');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has OverrideAction => (is => 'ro', isa => 'Paws::WAFV2::OverrideAction');
  has Priority => (is => 'ro', isa => 'Int', required => 1);
  has RuleLabels => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::Label]');
  has Statement => (is => 'ro', isa => 'Paws::WAFV2::Statement', required => 1);
  has VisibilityConfig => (is => 'ro', isa => 'Paws::WAFV2::VisibilityConfig', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::Rule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::Rule object:

  $service_obj->Method(Att1 => { Action => $value, ..., VisibilityConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::Rule object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

A single rule, which you can use in a WebACL or RuleGroup to identify
web requests that you want to allow, block, or count. Each rule
includes one top-level Statement that WAF uses to identify matching web
requests, and parameters that govern how WAF handles them.

=head1 ATTRIBUTES


=head2 Action => L<Paws::WAFV2::RuleAction>

The action that WAF should take on a web request when it matches the
rule statement. Settings at the web ACL level can override the rule
action setting.

This is used only for rules whose statements do not reference a rule
group. Rule statements that reference a rule group include
C<RuleGroupReferenceStatement> and C<ManagedRuleGroupStatement>.

You must specify either this C<Action> setting or the rule
C<OverrideAction> setting, but not both:

=over

=item *

If the rule statement does not reference a rule group, use this rule
action setting and not the rule override action setting.

=item *

If the rule statement references a rule group, use the override action
setting and not this action setting.

=back



=head2 B<REQUIRED> Name => Str

The name of the rule. You can't change the name of a C<Rule> after you
create it.


=head2 OverrideAction => L<Paws::WAFV2::OverrideAction>

The override action to apply to the rules in a rule group. Used only
for rule statements that reference a rule group, like
C<RuleGroupReferenceStatement> and C<ManagedRuleGroupStatement>.

Set the override action to none to leave the rule actions in effect.
Set it to count to only count matches, regardless of the rule action
settings.

In a Rule, you must specify either this C<OverrideAction> setting or
the rule C<Action> setting, but not both:

=over

=item *

If the rule statement references a rule group, use this override action
setting and not the action setting.

=item *

If the rule statement does not reference a rule group, use the rule
action setting and not this rule override action setting.

=back



=head2 B<REQUIRED> Priority => Int

If you define more than one C<Rule> in a C<WebACL>, WAF evaluates each
request against the C<Rules> in order based on the value of
C<Priority>. WAF processes rules with lower priority first. The
priorities don't need to be consecutive, but they must all be
different.


=head2 RuleLabels => ArrayRef[L<Paws::WAFV2::Label>]

Labels to apply to web requests that match the rule match statement.
WAF applies fully qualified labels to matching web requests. A fully
qualified label is the concatenation of a label namespace and a rule
label. The rule's rule group or web ACL defines the label namespace.

Rules that run after this rule in the web ACL can match against these
labels using a C<LabelMatchStatement>.

For each label, provide a case-sensitive string containing optional
namespaces and a label name, according to the following guidelines:

=over

=item *

Separate each component of the label with a colon.

=item *

Each namespace or name can have up to 128 characters.

=item *

You can specify up to 5 namespaces in a label.

=item *

Don't use the following reserved words in your label specification:
C<aws>, C<waf>, C<managed>, C<rulegroup>, C<webacl>,
C<regexpatternset>, or C<ipset>.

=back

For example, C<myLabelName> or C<nameSpace1:nameSpace2:myLabelName>.


=head2 B<REQUIRED> Statement => L<Paws::WAFV2::Statement>

The WAF processing statement for the rule, for example
ByteMatchStatement or SizeConstraintStatement.


=head2 B<REQUIRED> VisibilityConfig => L<Paws::WAFV2::VisibilityConfig>

Defines and enables Amazon CloudWatch metrics and web request sample
collection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

