# Generated by default/object.tt
package Paws::SageMaker::ResourceSpec;
  use Moose;
  has InstanceType => (is => 'ro', isa => 'Str');
  has SageMakerImageArn => (is => 'ro', isa => 'Str');
  has SageMakerImageVersionArn => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ResourceSpec

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ResourceSpec object:

  $service_obj->Method(Att1 => { InstanceType => $value, ..., SageMakerImageVersionArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ResourceSpec object:

  $result = $service_obj->Method(...);
  $result->Att1->InstanceType

=head1 DESCRIPTION

Specifies the ARN's of a SageMaker image and SageMaker image version,
and the instance type that the version runs on.

=head1 ATTRIBUTES


=head2 InstanceType => Str

The instance type that the image version runs on.


=head2 SageMakerImageArn => Str

The ARN of the SageMaker image that the image version belongs to.


=head2 SageMakerImageVersionArn => Str

The ARN of the image version created on the instance.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

