# Generated by default/object.tt
package Paws::SESv2::ContactListDestination;
  use Moose;
  has ContactListImportAction => (is => 'ro', isa => 'Str', required => 1);
  has ContactListName => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SESv2::ContactListDestination

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SESv2::ContactListDestination object:

  $service_obj->Method(Att1 => { ContactListImportAction => $value, ..., ContactListName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SESv2::ContactListDestination object:

  $result = $service_obj->Method(...);
  $result->Att1->ContactListImportAction

=head1 DESCRIPTION

An object that contains details about the action of a contact list.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ContactListImportAction => Str

E<gt>The type of action that you want to perform on the addresses.
Acceptable values:

=over

=item *

PUT: add the addresses to the contact list. If the record already
exists, it will override it with the new value.

=item *

DELETE: remove the addresses from the contact list.

=back



=head2 B<REQUIRED> ContactListName => Str

The name of the contact list.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SESv2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

