# Generated by default/object.tt
package Paws::Pinpoint::CampaignHook;
  use Moose;
  has LambdaFunctionName => (is => 'ro', isa => 'Str');
  has Mode => (is => 'ro', isa => 'Str');
  has WebUrl => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Pinpoint::CampaignHook

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Pinpoint::CampaignHook object:

  $service_obj->Method(Att1 => { LambdaFunctionName => $value, ..., WebUrl => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Pinpoint::CampaignHook object:

  $result = $service_obj->Method(...);
  $result->Att1->LambdaFunctionName

=head1 DESCRIPTION

Specifies settings for invoking an AWS Lambda function that customizes
a segment for a campaign.

=head1 ATTRIBUTES


=head2 LambdaFunctionName => Str

The name or Amazon Resource Name (ARN) of the AWS Lambda function that
Amazon Pinpoint invokes to customize a segment for a campaign.


=head2 Mode => Str

The mode that Amazon Pinpoint uses to invoke the AWS Lambda function.
Possible values are:

=over

=item *

FILTER - Invoke the function to customize the segment that's used by a
campaign.

=item *

DELIVERY - (Deprecated) Previously, invoked the function to send a
campaign through a custom channel. This functionality is not supported
anymore. To send a campaign through a custom channel, use the
CustomDeliveryConfiguration and CampaignCustomMessage objects of the
campaign.

=back



=head2 WebUrl => Str

The web URL that Amazon Pinpoint calls to invoke the AWS Lambda
function over HTTPS.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Pinpoint>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

