# Generated by default/object.tt
package Paws::Macie2::SimpleScopeTerm;
  use Moose;
  has Comparator => (is => 'ro', isa => 'Str', request_name => 'comparator', traits => ['NameInRequest']);
  has Key => (is => 'ro', isa => 'Str', request_name => 'key', traits => ['NameInRequest']);
  has Values => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'values', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::SimpleScopeTerm

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::SimpleScopeTerm object:

  $service_obj->Method(Att1 => { Comparator => $value, ..., Values => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::SimpleScopeTerm object:

  $result = $service_obj->Method(...);
  $result->Att1->Comparator

=head1 DESCRIPTION

Specifies a property-based condition that determines whether an S3
object is included or excluded from a classification job.

=head1 ATTRIBUTES


=head2 Comparator => Str

The operator to use in the condition. Valid values for each supported
property (key) are:

=over

=item *

OBJECT_EXTENSION - EQ (equals) or NE (not equals)

=item *

OBJECT_KEY - STARTS_WITH

=item *

OBJECT_LAST_MODIFIED_DATE - Any operator except CONTAINS

=item *

OBJECT_SIZE - Any operator except CONTAINS

=back



=head2 Key => Str

The object property to use in the condition.


=head2 Values => ArrayRef[Str|Undef]

An array that lists the values to use in the condition. If the value
for the key property is OBJECT_EXTENSION or OBJECT_KEY, this array can
specify multiple values and Amazon Macie uses OR logic to join the
values. Otherwise, this array can specify only one value.

Valid values for each supported property (key) are:

=over

=item *

OBJECT_EXTENSION - A string that represents the file name extension of
an object. For example: docx or pdf

=item *

OBJECT_KEY - A string that represents the key prefix (folder name or
path) of an object. For example: logs or awslogs/eventlogs. This value
applies a condition to objects whose keys (names) begin with the
specified value.

=item *

OBJECT_LAST_MODIFIED_DATE - The date and time (in UTC and extended ISO
8601 format) when an object was created or last changed, whichever is
latest. For example: 2020-09-28T14:31:13Z

=item *

OBJECT_SIZE - An integer that represents the storage size (in bytes) of
an object.

=back

Macie doesn't support use of wildcard characters in these values. Also,
string values are case sensitive.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

