# Generated by default/object.tt
package Paws::Macie2::ClassificationResult;
  use Moose;
  has AdditionalOccurrences => (is => 'ro', isa => 'Bool', request_name => 'additionalOccurrences', traits => ['NameInRequest']);
  has CustomDataIdentifiers => (is => 'ro', isa => 'Paws::Macie2::CustomDataIdentifiers', request_name => 'customDataIdentifiers', traits => ['NameInRequest']);
  has MimeType => (is => 'ro', isa => 'Str', request_name => 'mimeType', traits => ['NameInRequest']);
  has SensitiveData => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::SensitiveDataItem]', request_name => 'sensitiveData', traits => ['NameInRequest']);
  has SizeClassified => (is => 'ro', isa => 'Int', request_name => 'sizeClassified', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Paws::Macie2::ClassificationResultStatus', request_name => 'status', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::ClassificationResult

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::ClassificationResult object:

  $service_obj->Method(Att1 => { AdditionalOccurrences => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::ClassificationResult object:

  $result = $service_obj->Method(...);
  $result->Att1->AdditionalOccurrences

=head1 DESCRIPTION

Provides the details of a sensitive data finding, including the types,
number of occurrences, and locations of the sensitive data that was
detected.

=head1 ATTRIBUTES


=head2 AdditionalOccurrences => Bool

Specifies whether Amazon Macie detected additional occurrences of
sensitive data in the S3 object. A finding includes location data for a
maximum of 15 occurrences of sensitive data.

This value can help you determine whether to investigate additional
occurrences of sensitive data in an object. You can do this by
referring to the corresponding sensitive data discovery result for the
finding (ClassificationDetails.detailedResultsLocation).


=head2 CustomDataIdentifiers => L<Paws::Macie2::CustomDataIdentifiers>

The custom data identifiers that detected the sensitive data and the
number of occurrences of the data that they detected.


=head2 MimeType => Str

The type of content, as a MIME type, that the finding applies to. For
example, application/gzip, for a GNU Gzip compressed archive file, or
application/pdf, for an Adobe Portable Document Format file.


=head2 SensitiveData => ArrayRef[L<Paws::Macie2::SensitiveDataItem>]

The category, types, and number of occurrences of the sensitive data
that produced the finding.


=head2 SizeClassified => Int

The total size, in bytes, of the data that the finding applies to.


=head2 Status => L<Paws::Macie2::ClassificationResultStatus>

The status of the finding.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

