# Generated by default/object.tt
package Paws::Macie2::BlockPublicAccess;
  use Moose;
  has BlockPublicAcls => (is => 'ro', isa => 'Bool', request_name => 'blockPublicAcls', traits => ['NameInRequest']);
  has BlockPublicPolicy => (is => 'ro', isa => 'Bool', request_name => 'blockPublicPolicy', traits => ['NameInRequest']);
  has IgnorePublicAcls => (is => 'ro', isa => 'Bool', request_name => 'ignorePublicAcls', traits => ['NameInRequest']);
  has RestrictPublicBuckets => (is => 'ro', isa => 'Bool', request_name => 'restrictPublicBuckets', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::BlockPublicAccess

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::BlockPublicAccess object:

  $service_obj->Method(Att1 => { BlockPublicAcls => $value, ..., RestrictPublicBuckets => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::BlockPublicAccess object:

  $result = $service_obj->Method(...);
  $result->Att1->BlockPublicAcls

=head1 DESCRIPTION

Provides information about the block public access settings for an S3
bucket. These settings can apply to a bucket at the account level or
bucket level. For detailed information about each setting, see Blocking
public access to your Amazon S3 storage
(https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html)
in the I<Amazon Simple Storage Service User Guide>.

=head1 ATTRIBUTES


=head2 BlockPublicAcls => Bool

Specifies whether Amazon S3 blocks public access control lists (ACLs)
for the bucket and objects in the bucket.


=head2 BlockPublicPolicy => Bool

Specifies whether Amazon S3 blocks public bucket policies for the
bucket.


=head2 IgnorePublicAcls => Bool

Specifies whether Amazon S3 ignores public ACLs for the bucket and
objects in the bucket.


=head2 RestrictPublicBuckets => Bool

Specifies whether Amazon S3 restricts public bucket policies for the
bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

