# Generated by default/object.tt
package Paws::LookoutMetrics::AnomalyDetectorSummary;
  use Moose;
  has AnomalyDetectorArn => (is => 'ro', isa => 'Str');
  has AnomalyDetectorDescription => (is => 'ro', isa => 'Str');
  has AnomalyDetectorName => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has LastModificationTime => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'Paws::LookoutMetrics::TagMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::AnomalyDetectorSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::AnomalyDetectorSummary object:

  $service_obj->Method(Att1 => { AnomalyDetectorArn => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::AnomalyDetectorSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->AnomalyDetectorArn

=head1 DESCRIPTION

Contains information about an an anomaly detector.

=head1 ATTRIBUTES


=head2 AnomalyDetectorArn => Str

The ARN of the detector.


=head2 AnomalyDetectorDescription => Str

A description of the detector.


=head2 AnomalyDetectorName => Str

The name of the detector.


=head2 CreationTime => Str

The time at which the detector was created.


=head2 LastModificationTime => Str

The time at which the detector was last modified.


=head2 Status => Str

The status of detector.


=head2 Tags => L<Paws::LookoutMetrics::TagMap>

The detector's tags
(https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

