# Generated by default/object.tt
package Paws::Lightsail::CacheBehavior;
  use Moose;
  has Behavior => (is => 'ro', isa => 'Str', request_name => 'behavior', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::CacheBehavior

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::CacheBehavior object:

  $service_obj->Method(Att1 => { Behavior => $value, ..., Behavior => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::CacheBehavior object:

  $result = $service_obj->Method(...);
  $result->Att1->Behavior

=head1 DESCRIPTION

Describes the default cache behavior of an Amazon Lightsail content
delivery network (CDN) distribution.

=head1 ATTRIBUTES


=head2 Behavior => Str

The cache behavior of the distribution.

The following cache behaviors can be specified:

=over

=item *

B<C<cache> > - This option is best for static sites. When specified,
your distribution caches and serves your entire website as static
content. This behavior is ideal for websites with static content that
doesn't change depending on who views it, or for websites that don't
use cookies, headers, or query strings to personalize content.

=item *

B<C<dont-cache> > - This option is best for sites that serve a mix of
static and dynamic content. When specified, your distribution caches
and serve only the content that is specified in the distribution's
C<CacheBehaviorPerPath> parameter. This behavior is ideal for websites
or web applications that use cookies, headers, and query strings to
personalize content for individual users.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

