# Generated by default/object.tt
package Paws::Kendra::JwtTokenTypeConfiguration;
  use Moose;
  has ClaimRegex => (is => 'ro', isa => 'Str');
  has GroupAttributeField => (is => 'ro', isa => 'Str');
  has Issuer => (is => 'ro', isa => 'Str');
  has KeyLocation => (is => 'ro', isa => 'Str', required => 1);
  has SecretManagerArn => (is => 'ro', isa => 'Str');
  has URL => (is => 'ro', isa => 'Str');
  has UserNameAttributeField => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::JwtTokenTypeConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::JwtTokenTypeConfiguration object:

  $service_obj->Method(Att1 => { ClaimRegex => $value, ..., UserNameAttributeField => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::JwtTokenTypeConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ClaimRegex

=head1 DESCRIPTION

Configuration information for the JWT token type.

=head1 ATTRIBUTES


=head2 ClaimRegex => Str

The regular expression that identifies the claim.


=head2 GroupAttributeField => Str

The group attribute field.


=head2 Issuer => Str

The issuer of the token.


=head2 B<REQUIRED> KeyLocation => Str

The location of the key.


=head2 SecretManagerArn => Str

The Amazon Resource Name (arn) of the secret.


=head2 URL => Str

The signing key URL.


=head2 UserNameAttributeField => Str

The user name attribute field.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

