# Generated by default/object.tt
package Paws::Kendra::DataSourceConfiguration;
  use Moose;
  has ConfluenceConfiguration => (is => 'ro', isa => 'Paws::Kendra::ConfluenceConfiguration');
  has DatabaseConfiguration => (is => 'ro', isa => 'Paws::Kendra::DatabaseConfiguration');
  has GoogleDriveConfiguration => (is => 'ro', isa => 'Paws::Kendra::GoogleDriveConfiguration');
  has OneDriveConfiguration => (is => 'ro', isa => 'Paws::Kendra::OneDriveConfiguration');
  has S3Configuration => (is => 'ro', isa => 'Paws::Kendra::S3DataSourceConfiguration');
  has SalesforceConfiguration => (is => 'ro', isa => 'Paws::Kendra::SalesforceConfiguration');
  has ServiceNowConfiguration => (is => 'ro', isa => 'Paws::Kendra::ServiceNowConfiguration');
  has SharePointConfiguration => (is => 'ro', isa => 'Paws::Kendra::SharePointConfiguration');
  has WebCrawlerConfiguration => (is => 'ro', isa => 'Paws::Kendra::WebCrawlerConfiguration');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::DataSourceConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::DataSourceConfiguration object:

  $service_obj->Method(Att1 => { ConfluenceConfiguration => $value, ..., WebCrawlerConfiguration => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::DataSourceConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->ConfluenceConfiguration

=head1 DESCRIPTION

Configuration information for a Amazon Kendra data source.

=head1 ATTRIBUTES


=head2 ConfluenceConfiguration => L<Paws::Kendra::ConfluenceConfiguration>

Provides configuration information for connecting to a Confluence data
source.


=head2 DatabaseConfiguration => L<Paws::Kendra::DatabaseConfiguration>

Provides information necessary to create a data source connector for a
database.


=head2 GoogleDriveConfiguration => L<Paws::Kendra::GoogleDriveConfiguration>

Provides configuration for data sources that connect to Google Drive.


=head2 OneDriveConfiguration => L<Paws::Kendra::OneDriveConfiguration>

Provides configuration for data sources that connect to Microsoft
OneDrive.


=head2 S3Configuration => L<Paws::Kendra::S3DataSourceConfiguration>

Provides information to create a data source connector for a document
repository in an Amazon S3 bucket.


=head2 SalesforceConfiguration => L<Paws::Kendra::SalesforceConfiguration>

Provides configuration information for data sources that connect to a
Salesforce site.


=head2 ServiceNowConfiguration => L<Paws::Kendra::ServiceNowConfiguration>

Provides configuration for data sources that connect to ServiceNow
instances.


=head2 SharePointConfiguration => L<Paws::Kendra::SharePointConfiguration>

Provides information necessary to create a data source connector for a
Microsoft SharePoint site.


=head2 WebCrawlerConfiguration => L<Paws::Kendra::WebCrawlerConfiguration>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

