# Generated by default/object.tt
package Paws::IoTEvents::SetTimerAction;
  use Moose;
  has DurationExpression => (is => 'ro', isa => 'Str', request_name => 'durationExpression', traits => ['NameInRequest']);
  has Seconds => (is => 'ro', isa => 'Int', request_name => 'seconds', traits => ['NameInRequest']);
  has TimerName => (is => 'ro', isa => 'Str', request_name => 'timerName', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::SetTimerAction

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::SetTimerAction object:

  $service_obj->Method(Att1 => { DurationExpression => $value, ..., TimerName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::SetTimerAction object:

  $result = $service_obj->Method(...);
  $result->Att1->DurationExpression

=head1 DESCRIPTION

Information needed to set the timer.

=head1 ATTRIBUTES


=head2 DurationExpression => Str

The duration of the timer, in seconds. You can use a string expression
that includes numbers, variables
(C<$variable.E<lt>variable-nameE<gt>>), and input values
(C<$input.E<lt>input-nameE<gt>.E<lt>path-to-datumE<gt>>) as the
duration. The range of the duration is 1-31622400 seconds. To ensure
accuracy, the minimum duration is 60 seconds. The evaluated result of
the duration is rounded down to the nearest whole number.


=head2 Seconds => Int

The number of seconds until the timer expires. The minimum value is 60
seconds to ensure accuracy. The maximum value is 31622400 seconds.


=head2 B<REQUIRED> TimerName => Str

The name of the timer.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

