# Generated by default/object.tt
package Paws::IoTAnalytics::SchemaDefinition;
  use Moose;
  has Columns => (is => 'ro', isa => 'ArrayRef[Paws::IoTAnalytics::Column]', request_name => 'columns', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTAnalytics::SchemaDefinition

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTAnalytics::SchemaDefinition object:

  $service_obj->Method(Att1 => { Columns => $value, ..., Columns => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTAnalytics::SchemaDefinition object:

  $result = $service_obj->Method(...);
  $result->Att1->Columns

=head1 DESCRIPTION

Information needed to define a schema.

=head1 ATTRIBUTES


=head2 Columns => ArrayRef[L<Paws::IoTAnalytics::Column>]

Specifies one or more columns that store your data.

Each schema can have up to 100 columns. Each column can have up to 100
nested types.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTAnalytics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

